/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.world.level.block.Block;
import org.jspecify.annotations.Nullable;

public final class BlockColorRegistryImpl {
    private static @Nullable BlockColors blockColors;
    private static @Nullable Map<Block, BlockColor> map;

    public static void initialize(BlockColors blockColors) {
        if (BlockColorRegistryImpl.blockColors != null) {
            return;
        }
        BlockColorRegistryImpl.blockColors = blockColors;
        map.forEach((block, color) -> blockColors.register(color, new Block[]{block}));
        map = null;
    }

    public static void register(BlockColor color, Block ... blocks) {
        if (blockColors != null) {
            blockColors.register(color, blocks);
        } else {
            for (Block block : blocks) {
                map.put(block, color);
            }
        }
    }

    static {
        map = new IdentityHashMap<Block, BlockColor>();
    }
}

