/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.fabric.api.client.rendering.v1.InvalidateRenderStateCallback;
import net.fabricmc.fabric.api.client.rendering.v1.level.LevelRenderEvents;
import net.fabricmc.fabric.impl.client.rendering.level.LevelExtractionContextImpl;
import net.fabricmc.fabric.impl.client.rendering.level.LevelRenderContextImpl;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.WorldBorderRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.chunk.ChunkSectionsToRender;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.client.renderer.state.WorldBorderRenderState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private RenderBuffers renderBuffers;
    @Shadow
    @Final
    private LevelRenderState levelRenderState;
    @Shadow
    private @Nullable ClientLevel level;
    @Shadow
    @Final
    private SubmitNodeStorage submitNodeStorage;
    @Unique
    private final LevelRenderContextImpl renderContext = new LevelRenderContextImpl();
    @Unique
    private final LevelExtractionContextImpl extractionContext = new LevelExtractionContextImpl();

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void beforeRender(GraphicsResourceAllocator allocator, DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, Matrix4f viewMatrix, Matrix4f projectionMatrix, Matrix4f cullProjectionMatrix, GpuBufferSlice fogBuffer, Vector4f fogColor, boolean renderSky, CallbackInfo ci) {
        this.extractionContext.prepare(this.minecraft.gameRenderer, (LevelRenderer)this, this.levelRenderState, this.level, deltaTracker, renderBlockOutline, camera, viewMatrix, cullProjectionMatrix);
    }

    @ModifyExpressionValue(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/client/renderer/culling/Frustum;")})
    private Frustum onSetupFrustum(Frustum frustum) {
        this.extractionContext.setFrustum(frustum);
        return frustum;
    }

    @Inject(method={"extractBlockOutline"}, at={@At(value="RETURN")})
    private void afterBlockOutlineExtraction(Camera camera, LevelRenderState renderStates, CallbackInfo ci) {
        ((LevelRenderEvents.AfterBlockOutlineExtraction)LevelRenderEvents.AFTER_BLOCK_OUTLINE_EXTRACTION.invoker()).afterBlockOutlineExtraction(this.extractionContext, this.minecraft.hitResult);
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldBorderRenderer;extract(Lnet/minecraft/world/level/border/WorldBorder;FLnet/minecraft/world/phys/Vec3;DLnet/minecraft/client/renderer/state/WorldBorderRenderState;)V")})
    private void onWorldBorderExtraction(WorldBorderRenderer instance, WorldBorder worldBorder, float tickProgress, Vec3 vec3d, double viewDistanceBlocks, WorldBorderRenderState worldBorderRenderState, Operation<Void> original) {
        original.call(new Object[]{instance, worldBorder, Float.valueOf(tickProgress), vec3d, viewDistanceBlocks, worldBorderRenderState});
        ((LevelRenderEvents.EndExtraction)LevelRenderEvents.END_EXTRACTION.invoker()).endExtraction(this.extractionContext);
    }

    @ModifyExpressionValue(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareChunkRenders(Lorg/joml/Matrix4fc;DDD)Lnet/minecraft/client/renderer/chunk/ChunkSectionsToRender;")})
    private ChunkSectionsToRender onRenderBlockLayers(ChunkSectionsToRender chunkSectionsToRender) {
        this.renderContext.prepare(this.minecraft.gameRenderer, (LevelRenderer)this, this.levelRenderState, chunkSectionsToRender, (SubmitNodeCollector)this.submitNodeStorage, (MultiBufferSource)this.renderBuffers.bufferSource());
        return chunkSectionsToRender;
    }

    @WrapOperation(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/ChunkSectionsToRender;renderGroup(Lnet/minecraft/client/renderer/chunk/ChunkSectionLayerGroup;Lcom/mojang/blaze3d/textures/GpuSampler;)V", ordinal=0)})
    private void wrapRenderOpaqueTerrain(ChunkSectionsToRender chunkSectionsToRender, ChunkSectionLayerGroup group, GpuSampler sampler, Operation<Void> original) {
        ((LevelRenderEvents.StartMain)LevelRenderEvents.START_MAIN.invoker()).startMain(this.renderContext);
        original.call(new Object[]{chunkSectionsToRender, group, sampler});
        ((LevelRenderEvents.AfterOpaqueTerrain)LevelRenderEvents.AFTER_OPAQUE_TERRAIN.invoker()).afterOpaqueTerrain(this.renderContext);
    }

    @ModifyExpressionValue(method={"lambda$addMainPass$0"}, at={@At(value="NEW", target="Lcom/mojang/blaze3d/vertex/PoseStack;")})
    private PoseStack onCreatePoseStack(PoseStack poseStack) {
        this.renderContext.setPoseStack(poseStack);
        return poseStack;
    }

    @Inject(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=solidFeatures"})})
    private void afterCollectSubmits(CallbackInfo ci) {
        ((LevelRenderEvents.CollectSubmits)LevelRenderEvents.COLLECT_SUBMITS.invoker()).collectSubmits(this.renderContext);
    }

    @Inject(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void afterRenderSolidFeatures(CallbackInfo ci) {
        ((LevelRenderEvents.AfterSolidFeatures)LevelRenderEvents.AFTER_SOLID_FEATURES.invoker()).afterSolidFeatures(this.renderContext);
    }

    @Inject(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=destroyProgress"})})
    private void afterRenderTranslucentFeatures(CallbackInfo ci) {
        ((LevelRenderEvents.AfterTranslucentFeatures)LevelRenderEvents.AFTER_TRANSLUCENT_FEATURES.invoker()).afterTranslucentFeatures(this.renderContext);
    }

    @Inject(method={"renderBlockOutline"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/state/CameraRenderState;pos:Lnet/minecraft/world/phys/Vec3;", opcode=180)}, cancellable=true)
    private void beforeRenderBlockOutline(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, boolean translucent, LevelRenderState levelRenderState, CallbackInfo ci) {
        if (!((LevelRenderEvents.BeforeBlockOutline)LevelRenderEvents.BEFORE_BLOCK_OUTLINE.invoker()).beforeBlockOutline(this.renderContext, this.renderContext.levelState().blockOutlineRenderState)) {
            bufferSource.endLastBatch();
            ci.cancel();
        }
    }

    @Inject(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;finalizeGizmoCollection()V")})
    private void beforeCollectGizmos(CallbackInfo ci) {
        ((LevelRenderEvents.BeforeGizmos)LevelRenderEvents.BEFORE_GIZMOS.invoker()).beforeGizmos(this.renderContext);
    }

    @WrapOperation(method={"lambda$addMainPass$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/ChunkSectionsToRender;renderGroup(Lnet/minecraft/client/renderer/chunk/ChunkSectionLayerGroup;Lcom/mojang/blaze3d/textures/GpuSampler;)V", ordinal=1)})
    private void wrapRenderTranslucentTerrain(ChunkSectionsToRender chunkSectionsToRender, ChunkSectionLayerGroup group, GpuSampler sampler, Operation<Void> original) {
        ((LevelRenderEvents.BeforeTranslucentTerrain)LevelRenderEvents.BEFORE_TRANSLUCENT_TERRAIN.invoker()).beforeTranslucentTerrain(this.renderContext);
        original.call(new Object[]{chunkSectionsToRender, group, sampler});
        ((LevelRenderEvents.AfterTranslucentTerrain)LevelRenderEvents.AFTER_TRANSLUCENT_TERRAIN.invoker()).afterTranslucentTerrain(this.renderContext);
    }

    @Inject(method={"lambda$addMainPass$0"}, at={@At(value="RETURN")})
    private void endMainRender(CallbackInfo ci) {
        ((LevelRenderEvents.EndMain)LevelRenderEvents.END_MAIN.invoker()).endMain(this.renderContext);
    }

    @Inject(method={"allChanged()V"}, at={@At(value="HEAD")})
    private void onReload(CallbackInfo ci) {
        ((InvalidateRenderStateCallback)InvalidateRenderStateCallback.EVENT.invoker()).onInvalidate();
    }
}

