/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.conditions;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.DefaultResourceConditionTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceConditionsImpl
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fabric Resource Conditions");
    public static class_7699 currentFeatures = null;
    public static final ThreadLocal<Map<class_5321<?>, Set<class_2960>>> LOADED_TAGS = new ThreadLocal();

    public void onInitialize() {
        ResourceConditions.register(DefaultResourceConditionTypes.TRUE);
        ResourceConditions.register(DefaultResourceConditionTypes.NOT);
        ResourceConditions.register(DefaultResourceConditionTypes.AND);
        ResourceConditions.register(DefaultResourceConditionTypes.OR);
        ResourceConditions.register(DefaultResourceConditionTypes.ALL_MODS_LOADED);
        ResourceConditions.register(DefaultResourceConditionTypes.ANY_MODS_LOADED);
        ResourceConditions.register(DefaultResourceConditionTypes.TAGS_POPULATED);
        ResourceConditions.register(DefaultResourceConditionTypes.FEATURES_ENABLED);
        ResourceConditions.register(DefaultResourceConditionTypes.REGISTRY_CONTAINS);
    }

    public static boolean applyResourceConditions(JsonObject obj, String dataType, class_2960 key, @Nullable class_7225.class_7874 registryLookup) {
        boolean debugLogEnabled = LOGGER.isDebugEnabled();
        if (obj.has("fabric:load_conditions")) {
            DataResult conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("fabric:load_conditions"));
            if (conditions.isSuccess()) {
                boolean matched = ((ResourceCondition)conditions.getOrThrow()).test(registryLookup);
                if (debugLogEnabled) {
                    String verdict = matched ? "Allowed" : "Rejected";
                    LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, dataType, key});
                }
                return matched;
            }
            LOGGER.error("Failed to parse resource conditions for file of type {} with id {}, skipping: {}", new Object[]{dataType, key, ((DataResult.Error)conditions.error().get()).message()});
        }
        return true;
    }

    public static boolean conditionsMet(List<ResourceCondition> conditions, @Nullable class_7225.class_7874 registryLookup, boolean and) {
        for (ResourceCondition condition : conditions) {
            if (condition.test(registryLookup) == and) continue;
            return !and;
        }
        return and;
    }

    public static boolean modsLoaded(List<String> modIds, boolean and) {
        for (String modId : modIds) {
            if (FabricLoader.getInstance().isModLoaded(modId) == and) continue;
            return !and;
        }
        return and;
    }

    public static void setTags(List<class_3505.class_6863<?>> tags) {
        IdentityHashMap tagMap = new IdentityHashMap();
        for (class_3505.class_6863<?> registryTags : tags) {
            tagMap.put(registryTags.comp_328(), registryTags.comp_329().keySet());
        }
        LOADED_TAGS.set(tagMap);
    }

    public static boolean tagsPopulated(class_2960 registryId, List<class_2960> tags) {
        Map<class_5321<?>, Set<class_2960>> tagMap = LOADED_TAGS.get();
        if (tagMap == null) {
            LOGGER.warn("Can't retrieve registry {}, failing tags_populated resource condition check", (Object)registryId);
            return false;
        }
        Set<class_2960> tagSet = tagMap.get(class_5321.method_29180((class_2960)registryId));
        if (tagSet == null) {
            return tags.isEmpty();
        }
        return tagSet.containsAll(tags);
    }

    public static boolean featuresEnabled(Collection<class_2960> features) {
        MutableBoolean foundUnknown = new MutableBoolean();
        class_7699 set = class_7701.field_40180.method_45388(features, id -> {
            LOGGER.info("Found unknown feature {}, treating it as failure", id);
            foundUnknown.setTrue();
        });
        if (foundUnknown.booleanValue()) {
            return false;
        }
        if (currentFeatures == null) {
            LOGGER.warn("Can't retrieve current features, failing features_enabled resource condition check.");
            return false;
        }
        return set.method_45400(currentFeatures);
    }

    public static boolean registryContains(@Nullable class_7225.class_7874 registryLookup, class_2960 registryId, List<class_2960> entries) {
        class_5321 registryKey = class_5321.method_29180((class_2960)registryId);
        if (registryLookup == null) {
            LOGGER.warn("Can't retrieve registry {}, failing registry_contains resource condition check", (Object)registryId);
            return false;
        }
        Optional wrapper = registryLookup.method_46759(registryKey);
        if (wrapper.isPresent()) {
            for (class_2960 id : entries) {
                if (!((class_7225.class_7226)wrapper.get()).method_46746(class_5321.method_29179((class_5321)registryKey, (class_2960)id)).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return entries.isEmpty();
    }
}

