/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Stream;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.GroupResourcePack;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;

/**
 * Represents a vanilla built-in resource pack with support for modded content.
 *
 * <p>Vanilla resources are provided as usual through the original resource pack (if not overridden),
 * all other resources will be searched for in the provided modded resource packs.</p>
 */
public class FabricWrappedVanillaResourcePack extends GroupResourcePack {
	private final class_3255 originalResourcePack;

	public FabricWrappedVanillaResourcePack(class_3255 originalResourcePack, List<ModResourcePack> modResourcePacks) {
		// Mod resource packs have higher priority, add them last (so vanilla assets can be overridden)
		super(class_3264.field_14188, Stream.concat(Stream.of(originalResourcePack), modResourcePacks.stream()).toList());
		this.originalResourcePack = originalResourcePack;
	}

	@Override
	public class_7367<InputStream> method_14410(String... pathSegments) {
		return this.originalResourcePack.method_14410(pathSegments);
	}

	@Override
	public <T> @Nullable T method_14407(class_3270<T> metaReader) throws IOException {
		return this.originalResourcePack.method_14407(metaReader);
	}

	@Override
	public String method_14409() {
		return this.originalResourcePack.method_14409();
	}
}
