/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader.client;

import java.util.ArrayList;
import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.client.resource.loader.FabricWrappedVanillaResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.minecraft.class_1065;
import net.minecraft.class_2561;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

@Mixin(class_1065.class)
public class DefaultClientResourcePackProviderMixin {
	/**
	 * Injects into the method which registers/creates vanilla built-in resource packs,
	 * and replaces the local {@link net.minecraft.class_3288.class_7680}
	 * instance with our custom wrapper that supports loading from mods.
	 */
	@ModifyArg(
			method = "create(Ljava/lang/String;Lnet/minecraft/resource/ResourcePackProfile$PackFactory;Lnet/minecraft/text/Text;)Lnet/minecraft/resource/ResourcePackProfile;",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/resource/ResourcePackProfile;create(Ljava/lang/String;Lnet/minecraft/text/Text;ZLnet/minecraft/resource/ResourcePackProfile$PackFactory;Lnet/minecraft/resource/ResourceType;Lnet/minecraft/resource/ResourcePackProfile$InsertionPosition;Lnet/minecraft/resource/ResourcePackSource;)Lnet/minecraft/resource/ResourcePackProfile;"
			),
			index = 3
	)
	private class_3288.class_7680 onCreateVanillaBuiltinResourcePack(String name, class_2561 displayName, boolean alwaysEnabled,
			class_3288.class_7680 packFactory, class_3264 type, class_3288.class_3289 position, class_5352 source) {
		return new class_3288.class_7680() {
			@Override
			public class_3262 method_52424(String name) {
				return new FabricWrappedVanillaResourcePack((class_3255) packFactory.method_52424(name), getModResourcePacks(name));
			}

			@Override
			public class_3262 method_52425(String string, class_3288.class_7679 metadata) {
				// VanillaResourcePackProvider does not handle overlays
				return method_52424(name);
			}
		};
	}

	/**
	 * {@return all baked-in mod resource packs that provide resources in the specified subPath}.
	 */
	private static List<ModResourcePack> getModResourcePacks(String subPath) {
		List<ModResourcePack> packs = new ArrayList<>();
		ModResourcePackUtil.appendModResourcePacks(packs, class_3264.field_14188, subPath);
		return packs;
	}
}
