/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.fabric.impl.resource.loader.client.pack.ProgrammerArtResourcePack;
import net.minecraft.class_1066;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;

@Mixin(class_1066.class)
public class ClientBuiltinResourcePackProviderMixin {
	@Inject(method = "register", at = @At("RETURN"))
	private void addBuiltinResourcePacks(Consumer<class_3288> consumer, class_3288.class_5351 factory, CallbackInfo ci) {
		// Register mod and built-in resource packs after the vanilla built-in resource packs are registered.
		ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.method_14453(consumer, factory);
	}

	// ClientBuiltinResourcePackProvider#method_25454 first lambda.
	@Inject(method = "method_25457", at = @At("RETURN"), cancellable = true)
	private static void onSupplyZipProgrammerArtPack(File file, CallbackInfoReturnable<class_3262> cir) {
		class_3255 originalPack = (class_3255) cir.getReturnValue();
		cir.setReturnValue(new ProgrammerArtResourcePack(originalPack, getProgrammerArtModResourcePacks()));
	}

	// ClientBuiltinResourcePackProvider#method_25454 second lambda.
	@Inject(method = "method_25456", at = @At("RETURN"), cancellable = true)
	private static void onSupplyDirProgrammerArtPack(File file, CallbackInfoReturnable<class_3262> cir) {
		class_3255 originalPack = (class_3255) cir.getReturnValue();
		cir.setReturnValue(new ProgrammerArtResourcePack(originalPack, getProgrammerArtModResourcePacks()));
	}

	private static List<ModResourcePack> getProgrammerArtModResourcePacks() {
		List<ModResourcePack> packs = new ArrayList<>();
		ModResourcePackUtil.appendModResourcePacks(packs, class_3264.field_14188, "programmer_art");
		return packs;
	}
}
