/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.mojang.bridge.game.GameVersion;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_3264;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin")) continue;
            Path path = container.getRootPath();
            if (subPath != null) {
                Path childPath = path.resolve(subPath.replace("/", path.getFileSystem().getSeparator())).toAbsolutePath().normalize();
                if (!childPath.startsWith(path) || !Files.exists(childPath, new LinkOption[0])) continue;
                path = childPath;
            }
            if ((pack = new ModNioResourcePack(container.getMetadata(), path, type, null, ResourcePackActivationType.ALWAYS_ENABLED)).method_14406(type).isEmpty()) continue;
            packs.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, class_3264 type, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = info.getName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":" + type.method_31438((GameVersion)class_155.method_16673()) + ",\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }
}

