/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.loader.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1060;
import net.minecraft.class_1076;
import net.minecraft.class_1092;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_918;

@Mixin({
		/* public */
		class_1144.class, class_1092.class, class_1076.class, class_1060.class,
		/* private */
		class_761.class, class_776.class, class_918.class
})
public abstract class KeyedResourceReloadListenerClientMixin implements IdentifiableResourceReloadListener {
	@Unique
	private class_2960 id;
	@Unique
	private Collection<class_2960> dependencies;

	@Override
	public class_2960 getFabricId() {
		if (this.id == null) {
			Object self = this;

			if (self instanceof class_1144) {
				this.id = ResourceReloadListenerKeys.SOUNDS;
			} else if (self instanceof class_1092) {
				this.id = ResourceReloadListenerKeys.MODELS;
			} else if (self instanceof class_1076) {
				this.id = ResourceReloadListenerKeys.LANGUAGES;
			} else if (self instanceof class_1060) {
				this.id = ResourceReloadListenerKeys.TEXTURES;
			} else {
				this.id = class_2960.method_60656("private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
			}
		}

		return this.id;
	}

	@Override
	@SuppressWarnings({"ConstantConditions"})
	public Collection<class_2960> getFabricDependencies() {
		if (this.dependencies == null) {
			Object self = this;

			if (self instanceof class_1092 || self instanceof class_761) {
				this.dependencies = Collections.singletonList(ResourceReloadListenerKeys.TEXTURES);
			} else if (self instanceof class_918 || self instanceof class_776) {
				this.dependencies = Collections.singletonList(ResourceReloadListenerKeys.MODELS);
			} else {
				this.dependencies = Collections.emptyList();
			}
		}

		return this.dependencies;
	}
}
