/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackSorter;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import net.minecraft.class_5359;
import net.minecraft.class_6497;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import net.minecraft.class_8580;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModResourcePackUtil {
    public static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(ModResourcePackUtil.class);
    private static final String LOAD_ORDER_KEY = "fabric:resource_load_order";

    private ModResourcePackUtil() {
    }

    public static List<ModResourcePack> getModResourcePacks(FabricLoader fabricLoader, class_3264 type, @Nullable String subPath) {
        ModResourcePackSorter sorter = new ModResourcePackSorter();
        Collection containers = fabricLoader.getAllMods();
        List<String> allIds = containers.stream().map(ModContainer::getMetadata).map(ModMetadata::getId).toList();
        for (ModContainer container : containers) {
            ModNioResourcePack pack;
            ModMetadata metadata = container.getMetadata();
            String id = metadata.getId();
            if (metadata.getType().equals("builtin") || (pack = ModNioResourcePack.create(id, container, subPath, type, ResourcePackActivationType.ALWAYS_ENABLED, true)) == null) continue;
            sorter.addPack(pack);
            CustomValue loadOrder = metadata.getCustomValue(LOAD_ORDER_KEY);
            if (loadOrder == null) continue;
            if (loadOrder.getType() == CustomValue.CvType.OBJECT) {
                CustomValue.CvObject object = loadOrder.getAsObject();
                ModResourcePackUtil.addLoadOrdering(object, allIds, sorter, Order.BEFORE, id);
                ModResourcePackUtil.addLoadOrdering(object, allIds, sorter, Order.AFTER, id);
                continue;
            }
            LOGGER.error("[Fabric] Resource load order should be an object");
        }
        return sorter.getPacks();
    }

    public static void addLoadOrdering(CustomValue.CvObject object, List<String> allIds, ModResourcePackSorter sorter, Order order, String currentId) {
        ArrayList<String> modIds = new ArrayList<String>();
        CustomValue array = object.get(order.jsonKey);
        if (array == null) {
            return;
        }
        switch (array.getType()) {
            case STRING: {
                modIds.add(array.getAsString());
                break;
            }
            case ARRAY: {
                for (CustomValue id : array.getAsArray()) {
                    if (id.getType() != CustomValue.CvType.STRING) continue;
                    modIds.add(id.getAsString());
                }
                break;
            }
            default: {
                LOGGER.error("[Fabric] {} should be a string or an array", (Object)order.jsonKey);
                return;
            }
        }
        modIds.stream().filter(allIds::contains).forEach(modId -> sorter.addLoadOrdering((String)modId, currentId, order));
    }

    public static void refreshAutoEnabledPacks(List<class_3288> enabledProfiles, Map<String, class_3288> allProfiles) {
        LOGGER.debug("[Fabric] Starting internal pack sorting with: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
        enabledProfiles.removeIf(profile -> ((FabricResourcePackProfile)profile).fabric_isHidden());
        LOGGER.debug("[Fabric] Removed all internal packs, result: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
        ListIterator<class_3288> it = enabledProfiles.listIterator();
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        while (it.hasNext()) {
            class_3288 profile2 = it.next();
            seen.add(profile2.method_14463());
            for (class_3288 p : allProfiles.values()) {
                FabricResourcePackProfile fp = (FabricResourcePackProfile)p;
                if (!fp.fabric_isHidden() || !fp.fabric_parentsEnabled(seen) || !seen.add(p.method_14463())) continue;
                it.add(p);
                LOGGER.debug("[Fabric] cur @ {}, auto-enabled {}, currently enabled: {}", new Object[]{profile2.method_14463(), p.method_14463(), seen});
            }
        }
        LOGGER.debug("[Fabric] Final sorting result: {}", enabledProfiles.stream().map(class_3288::method_14463).toList());
    }

    public static boolean containsDefault(String filename, boolean modBundled) {
        return "pack.mcmeta".equals(filename) || modBundled && "pack.png".equals(filename);
    }

    public static InputStream getDefaultIcon() throws IOException {
        Optional loaderIconPath = FabricLoader.getInstance().getModContainer("fabric-resource-loader-v0").flatMap(resourceLoaderContainer -> resourceLoaderContainer.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)resourceLoaderContainer).findPath(arg_0)));
        if (loaderIconPath.isPresent()) {
            return Files.newInputStream((Path)loaderIconPath.get(), new OpenOption[0]);
        }
        return null;
    }

    public static InputStream openDefault(ModContainer container, class_3264 type, String filename) throws IOException {
        switch (filename) {
            case "pack.mcmeta": {
                String description = Objects.requireNonNullElse(container.getMetadata().getId(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(class_155.method_16673().method_70592(type), description, type);
                return IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
            case "pack.png": {
                Optional path = container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0));
                if (path.isPresent()) {
                    return Files.newInputStream((Path)path.get(), new OpenOption[0]);
                }
                return ModResourcePackUtil.getDefaultIcon();
            }
        }
        return null;
    }

    public static class_3272 getMetadataPack(class_11555 packVersion, class_2561 description) {
        return new class_3272(description, new class_6497((Comparable)packVersion));
    }

    public static JsonObject getMetadataPackJson(class_11555 packVersion, class_2561 description, class_3264 resourceType) {
        return ((JsonElement)class_3272.method_72360((class_3264)resourceType).encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ModResourcePackUtil.getMetadataPack(packVersion, description)).getOrThrow()).getAsJsonObject();
    }

    public static String serializeMetadata(class_11555 packVersion, String description, class_3264 resourceType) {
        JsonObject pack = ModResourcePackUtil.getMetadataPackJson(packVersion, (class_2561)class_2561.method_43470((String)description), resourceType);
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static class_2561 getName(ModMetadata info) {
        if (info.getId() != null) {
            return class_2561.method_43470((String)info.getId());
        }
        return class_2561.method_43469((String)"pack.name.fabricMod", (Object[])new Object[]{info.getId()});
    }

    public static class_7712 createDefaultDataConfiguration() {
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        ArrayList moddedResourcePacks = new ArrayList();
        modResourcePackCreator.method_14453(moddedResourcePacks::add);
        ArrayList<String> enabled = new ArrayList<String>(class_5359.field_25393.method_29547());
        ArrayList<String> disabled = new ArrayList<String>(class_5359.field_25393.method_29550());
        for (class_3288 profile : moddedResourcePacks) {
            if (profile.method_29483() == ModResourcePackCreator.RESOURCE_PACK_SOURCE) {
                enabled.add(profile.method_14463());
                continue;
            }
            class_3262 pack = profile.method_14458();
            try {
                if (pack instanceof ModNioResourcePack && ((ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) {
                    enabled.add(profile.method_14463());
                    continue;
                }
                disabled.add(profile.method_14463());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        return new class_7712(new class_5359(enabled, disabled), class_7701.field_40183);
    }

    public static class_5359 createTestServerSettings(List<String> enabled, List<String> disabled) {
        HashSet moddedProfiles = new HashSet();
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        modResourcePackCreator.method_14453(profile -> moddedProfiles.add(profile.method_14463()));
        ArrayList<String> moveToTheEnd = new ArrayList<String>();
        Iterator<String> it = enabled.iterator();
        while (it.hasNext()) {
            String profile2 = it.next();
            if (!moddedProfiles.contains(profile2)) continue;
            moveToTheEnd.add(profile2);
            it.remove();
        }
        enabled.addAll(moveToTheEnd);
        return new class_5359(enabled, disabled);
    }

    public static class_3283 createClientManager() {
        return new class_3283(new class_3285[]{new class_3286(new class_8580(path -> true)), new ModResourcePackCreator(class_3264.field_14190, true)});
    }

    public static enum Order {
        BEFORE("before"),
        AFTER("after");

        private final String jsonKey;

        private Order(String jsonKey) {
            this.jsonKey = jsonKey;
        }
    }
}

