/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;

public record PlaceholderResourcePack(PackType type, PackLocationInfo metadata) implements PackResources
{
    private static final Component DESCRIPTION_TEXT = Component.translatable((String)"pack.description.modResources");

    public PackMetadataSection getMetadata() {
        return ModResourcePackUtil.getMetadataPack(SharedConstants.getCurrentVersion().packVersion(this.type), DESCRIPTION_TEXT);
    }

    public @Nullable IoSupplier<InputStream> getRootResource(String ... segments) {
        if (segments.length > 0) {
            switch (segments[0]) {
                case "pack.mcmeta": {
                    return () -> {
                        DataResult result = PackMetadataSection.codecForPackType((PackType)this.type).encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.getMetadata());
                        String metadata = ((JsonElement)result.getOrThrow()).toString();
                        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
                    };
                }
                case "pack.png": {
                    return ModResourcePackUtil::getDefaultIcon;
                }
            }
        }
        return null;
    }

    public @Nullable IoSupplier<InputStream> getResource(PackType type, Identifier id) {
        return null;
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
    }

    public Set<String> getNamespaces(PackType type) {
        return Collections.emptySet();
    }

    public <T> @Nullable T getMetadataSection(MetadataSectionType<T> metaReader) {
        return (T)BuiltInMetadata.of((MetadataSectionType)PackMetadataSection.forPackType((PackType)this.type), (Object)this.getMetadata()).get(metaReader);
    }

    public PackLocationInfo location() {
        return this.metadata;
    }

    public String packId() {
        return "fabric";
    }

    public void close() {
    }

    public record Factory(PackType type, PackLocationInfo metadata) implements Pack.ResourcesSupplier
    {
        public PackResources openPrimary(PackLocationInfo var1) {
            return new PlaceholderResourcePack(this.type, this.metadata);
        }

        public PackResources openFull(PackLocationInfo var1, Pack.Metadata metadata) {
            return this.openPrimary(var1);
        }
    }
}

