/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PackRepository.class})
public abstract class PackRepositoryMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PackRepositoryMixin");
    @Shadow
    @Final
    @Mutable
    public Set<RepositorySource> sources;
    @Shadow
    private Map<String, Pack> available;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void construct(RepositorySource[] resourcePackProviders, CallbackInfo info) {
        this.sources = new LinkedHashSet<RepositorySource>(this.sources);
        boolean shouldAddServerProvider = false;
        for (RepositorySource provider : this.sources) {
            if (!(provider instanceof FolderRepositorySource) || ((FolderRepositorySource)provider).packSource != PackSource.WORLD && ((FolderRepositorySource)provider).packSource != PackSource.SERVER) continue;
            shouldAddServerProvider = true;
            break;
        }
        if (shouldAddServerProvider) {
            this.sources.add(new ModResourcePackCreator(PackType.SERVER_DATA));
        }
    }

    @Inject(method={"rebuildSelected"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;copyOf(Ljava/util/Collection;)Lcom/google/common/collect/ImmutableList;", shift=At.Shift.BEFORE)})
    private void handleAutoEnableDisable(Collection<String> enabledNames, CallbackInfoReturnable<List<Pack>> cir, @Local List<Pack> enabledAfterFirstRun) {
        ModResourcePackUtil.refreshAutoEnabledPacks(enabledAfterFirstRun, this.available);
    }

    @Inject(method={"addPack"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void handleAutoEnable(String profile, CallbackInfoReturnable<Boolean> cir, @Local List<Pack> newlyEnabled) {
        if (ModResourcePackCreator.POST_CHANGE_HANDLE_REQUIRED.contains(profile)) {
            ModResourcePackUtil.refreshAutoEnabledPacks(newlyEnabled, this.available);
        }
    }

    @Inject(method={"removePack"}, at={@At(value="INVOKE", target="Ljava/util/List;remove(Ljava/lang/Object;)Z")})
    private void handleAutoDisable(String profile, CallbackInfoReturnable<Boolean> cir, @Local List<Pack> enabled) {
        if (ModResourcePackCreator.POST_CHANGE_HANDLE_REQUIRED.contains(profile)) {
            Set currentlyEnabled = enabled.stream().map(Pack::getId).collect(Collectors.toSet());
            enabled.removeIf(p -> !((FabricResourcePackProfile)p).fabric_parentsEnabled(currentlyEnabled));
            LOGGER.debug("[Fabric] Internal pack auto-removed upon disabling {}, result: {}", (Object)profile, enabled.stream().map(Pack::getId).toList());
        }
    }
}

