/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_7662;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;

public record PlaceholderResourcePack(class_3264 type, class_9224 metadata) implements class_3262 {
	private static final class_2561 DESCRIPTION_TEXT = class_2561.method_43471("pack.description.modResources");

	public class_3272 getMetadata() {
		return ModResourcePackUtil.getMetadataPack(
				class_155.method_16673().method_70592(type),
				DESCRIPTION_TEXT
		);
	}

	@Nullable
	@Override
	public class_7367<InputStream> method_14410(String... segments) {
		if (segments.length > 0) {
			switch (segments[0]) {
			case "pack.mcmeta":
				return () -> {
					DataResult<JsonElement> result = class_3272.method_72360(type)
							.encodeStart(JsonOps.INSTANCE, getMetadata());
					String metadata = result.getOrThrow().toString();
					return IOUtils.toInputStream(metadata, StandardCharsets.UTF_8);
				};
			case "pack.png":
				return ModResourcePackUtil::getDefaultIcon;
			}
		}

		return null;
	}

	/**
	 * This pack has no actual contents.
	 */
	@Nullable
	@Override
	public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
		return null;
	}

	@Override
	public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
	}

	@Override
	public Set<String> method_14406(class_3264 type) {
		return Collections.emptySet();
	}

	@Nullable
	@Override
	public <T> T method_14407(class_7677<T> metaReader) {
		return class_7662.method_45174(class_3272.method_72356(type), getMetadata()).method_45173(metaReader);
	}

	@Override
	public class_9224 method_56926() {
		return metadata;
	}

	@Override
	public String method_14409() {
		return ModResourcePackCreator.FABRIC;
	}

	@Override
	public void close() {
	}

	public record Factory(class_3264 type, class_9224 metadata) implements class_3288.class_7680 {
		@Override
		public class_3262 method_52424(class_9224 var1) {
			return new PlaceholderResourcePack(this.type, metadata);
		}

		@Override
		public class_3262 method_52425(class_9224 var1, class_3288.class_7679 metadata) {
			return method_52424(var1);
		}
	}
}
