/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_7225;

public class ResourceManagerHelperImpl implements ResourceManagerHelper {
	private static final Map<class_3264, ResourceManagerHelperImpl> registryMap = new HashMap<>();

	private final ResourceLoader resourceLoader;

	private ResourceManagerHelperImpl(class_3264 type) {
		this.resourceLoader = ResourceLoader.get(type);
	}

	public static ResourceManagerHelperImpl get(class_3264 type) {
		return registryMap.computeIfAbsent(type, ResourceManagerHelperImpl::new);
	}

	@Override
	public void registerReloadListener(IdentifiableResourceReloadListener listener) {
		this.resourceLoader.registerReloader(listener.getFabricId(), listener);
		listener.getFabricDependencies().forEach(dependency -> this.resourceLoader.addReloaderOrdering(dependency, listener.getFabricId()));
	}

	@Override
	public void registerReloadListener(class_2960 identifier, Function<class_7225.class_7874, IdentifiableResourceReloadListener> listenerFactory) {
		this.resourceLoader.registerReloader(identifier, new class_3302() {
			@Override
			public CompletableFuture<Void> method_25931(class_11558 store, Executor prepareExecutor, class_4045 reloadSynchronizer, Executor applyExecutor) {
				class_7225.class_7874 registries = store.method_72362(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
				class_3302 resourceReloader = listenerFactory.apply(registries);

				return resourceReloader.method_25931(store, prepareExecutor, reloadSynchronizer, applyExecutor);
			}
		});
	}
}
