/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource;

import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.fabricmc.fabric.impl.resource.FabricResourceReloader;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_5349;

@Mixin({
		/* public */
		class_1863.class, class_2989.class, class_5349.class
		/* private */
})
public abstract class KeyedResourceReloaderMixin implements FabricResourceReloader {
	@Unique
	private class_2960 id;

	@Override
	@SuppressWarnings({"ConstantConditions"})
	public class_2960 fabric$getId() {
		if (this.id == null) {
			Object self = this;

			if (self instanceof class_1863) {
				this.id = ResourceReloaderKeys.Server.RECIPES;
			} else if (self instanceof class_2989) {
				this.id = ResourceReloaderKeys.Server.ADVANCEMENTS;
			} else if (self instanceof class_5349) {
				this.id = ResourceReloaderKeys.Server.FUNCTIONS;
			} else {
				this.id = class_2960.method_60656("private/" + self.getClass().getSimpleName().toLowerCase(Locale.ROOT));
			}
		}

		return this.id;
	}
}
