/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource;

import java.util.Set;
import java.util.function.Predicate;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.resource.v1.FabricResource;
import net.fabricmc.fabric.impl.resource.PackSourceTracker;
import net.fabricmc.fabric.impl.resource.pack.FabricPack;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_9224;

/**
 * Implements resource pack source tracking (for {@link FabricResource}).
 * {@link class_3262} doesn't hold a reference to its {@link net.minecraft.class_5352}
 * so we store the source in a global tracker when the resource packs are created.
 *
 * @see PackSourceTracker
 */
@Mixin(class_3288.class)
abstract class PackMixin implements FabricPack {
	@Unique
	private static final Predicate<Set<String>> DEFAULT_PARENT_PREDICATE = parents -> true;
	@Unique
	private Predicate<Set<String>> parentsPredicate = DEFAULT_PARENT_PREDICATE;

	@Shadow
	public abstract class_9224 location();

	@Inject(method = "open", at = @At("RETURN"))
	private void onCreateResourcePack(CallbackInfoReturnable<class_3262> cir) {
		PackSourceTracker.setSource(cir.getReturnValue(), location().comp_2331());
	}

	@Override
	public boolean fabric$isHidden() {
		return this.parentsPredicate != DEFAULT_PARENT_PREDICATE;
	}

	@Override
	public boolean fabric$parentsEnabled(Set<String> enabled) {
		return this.parentsPredicate.test(enabled);
	}

	@Override
	public void fabric$setParentsPredicate(Predicate<Set<String>> predicate) {
		this.parentsPredicate = predicate;
	}
}
