/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource.v1.reloader;

import net.minecraft.class_2960;

/**
 * This class contains default keys for various Minecraft resource reloaders.
 *
 * @see net.minecraft.class_3302
 */
public final class ResourceReloaderKeys {
	/**
	 * Represents the application phase before Vanilla resource reloaders are invoked.
	 *
	 * <p>No resource reloaders are assigned to this identifier.
	 *
	 * @see net.fabricmc.fabric.api.resource.v1.ResourceLoader#addReloaderOrdering(class_2960, class_2960)
	 */
	public static final class_2960 BEFORE_VANILLA = class_2960.method_60655("fabric", "before_vanilla");
	/**
	 * Represents the application phase after Vanilla resource reloaders are invoked.
	 *
	 * <p>No resource reloaders are assigned to this identifier.
	 *
	 * @see net.fabricmc.fabric.api.resource.v1.ResourceLoader#addReloaderOrdering(class_2960, class_2960)
	 */
	public static final class_2960 AFTER_VANILLA = class_2960.method_60655("fabric", "after_vanilla");

	private ResourceReloaderKeys() { }

	/**
	 * Keys for various client resource reloaders.
	 */
	public static final class Client {
		public static final class_2960 BLOCK_ENTITY_RENDERERS = class_2960.method_60656("block_entity_renderers");
		public static final class_2960 BLOCK_RENDER_MANAGER = class_2960.method_60656("block_render_manager");
		public static final class_2960 CLOUD_CELLS = class_2960.method_60656("cloud_cells");
		public static final class_2960 EQUIPMENT_MODELS = class_2960.method_60656("equipment_models");
		public static final class_2960 ENTITY_RENDERERS = class_2960.method_60656("entity_renderers");
		public static final class_2960 DRY_FOLIAGE_COLORMAP = class_2960.method_60656("dry_foliage_colormap");
		public static final class_2960 FOLIAGE_COLORMAP = class_2960.method_60656("foliage_colormap");
		public static final class_2960 FONTS = class_2960.method_60656("fonts");
		public static final class_2960 GRASS_COLORMAP = class_2960.method_60656("grass_colormap");
		public static final class_2960 ATLAS = class_2960.method_60656("atlas");
		public static final class_2960 LANGUAGES = class_2960.method_60656("languages");
		public static final class_2960 MODELS = class_2960.method_60656("models");
		public static final class_2960 PARTICLES = class_2960.method_60656("particles");
		public static final class_2960 SHADERS = class_2960.method_60656("shaders");
		public static final class_2960 SOUNDS = class_2960.method_60656("sounds");
		public static final class_2960 SPLASH_TEXTS = class_2960.method_60656("splash_texts");
		public static final class_2960 TEXTURES = class_2960.method_60656("textures");
		public static final class_2960 WAYPOINT_STYLE_ASSETS = class_2960.method_60656("waypoint_style_assets");

		private Client() {
		}
	}

	/**
	 * Keys for various server resource reloaders.
	 */
	public static final class Server {
		public static final class_2960 ADVANCEMENTS = class_2960.method_60656("advancements");
		public static final class_2960 FUNCTIONS = class_2960.method_60656("functions");
		public static final class_2960 RECIPES = class_2960.method_60656("recipes");

		private Server() {
		}
	}
}
