/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.v1;

import net.fabricmc.fabric.api.resource.v1.DataResourceLoader;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5350;
import net.minecraft.class_7225;
import net.minecraft.class_7699;

// Used to inject into the ResourceReloader store.
public record SetupMarkerResourceReloader(class_5350 dataPackContents, class_7699 featureSet) implements class_4013 {
	@Override
	public void prepareSharedState(class_11558 store) {
		class_7225.class_7874 registries = this.dataPackContents.method_58297().method_58294();
		store.method_72363(DataResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY, registries);
		store.method_72363(DataResourceLoader.RELOADER_FEATURE_SET_KEY, this.featureSet);
		store.method_72363(DataResourceLoader.ADVANCEMENT_LOADER_KEY, this.dataPackContents.method_29473());
		store.method_72363(DataResourceLoader.RECIPE_MANAGER_KEY, this.dataPackContents.method_29471());
		store.method_72363(
				DataResourceLoader.DATA_RESOURCE_STORE_KEY,
				((FabricDataResourceStoreHolder) this.dataPackContents).fabric$getDataResourceStore()
		);
	}

	@Override
	public void method_14491(class_3300 manager) {
		// Do nothing.
	}
}
