/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.v1;

import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.resource.v1.FabricLifecycledResourceManager;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_6861;

@Mixin(class_6861.class)
public class MultiPackResourceManagerMixin implements FabricLifecycledResourceManager {
	@Unique
	private class_3264 resourceType;

	@Inject(method = "<init>", at = @At("TAIL"))
	private void init(class_3264 resourceType, List<class_3262> list, CallbackInfo ci) {
		this.resourceType = resourceType;
	}

	@Override
	public class_3264 fabric$getResourceType() {
		return this.resourceType;
	}
}
