/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.client;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public record PackTooltipComponent(Optional<Component> name, Optional<List<FormattedCharSequence>> description) implements TooltipComponent,
ClientTooltipComponent
{
    public int getHeight(Font font) {
        int height = 0;
        if (this.name.isPresent()) {
            Objects.requireNonNull(font);
            height += 9 + 2;
        }
        if (this.description.isPresent()) {
            int n = this.description.get().size();
            Objects.requireNonNull(font);
            height += n * 9 + 3;
        }
        if (this.name.isPresent() && this.description.isPresent()) {
            Objects.requireNonNull(font);
            height += 9;
        }
        return height;
    }

    public int getWidth(Font font) {
        return Math.max(this.name.map(arg_0 -> ((Font)font).width(arg_0)).orElse(0), this.description.map(description -> description.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0)).orElse(0));
    }

    public void renderText(GuiGraphics graphics, Font font, int x, int y) {
        if (this.name.isPresent()) {
            graphics.drawString(font, this.name.get(), x, y, -1, true);
            Objects.requireNonNull(font);
            y += 9 + 1;
            if (this.description.isPresent()) {
                Objects.requireNonNull(font);
                y += 9;
            }
        }
        if (this.description.isPresent()) {
            for (FormattedCharSequence line : this.description.get()) {
                graphics.drawString(font, line, x, y, -1, true);
                Objects.requireNonNull(font);
                y += 9 + 1;
            }
        }
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
        if (this.name.isPresent() && this.description.isPresent()) {
            Objects.requireNonNull(font);
            int n = x + this.getWidth(font);
            Objects.requireNonNull(font);
            graphics.fill(x, y + 9 + 4, n, y + 9 + 5, 0xFF000000 | ChatFormatting.GRAY.getColor());
        }
    }
}

