/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.screen;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_309;
import net.minecraft.class_437;

@Mixin(class_309.class)
abstract class KeyboardMixin {
	// private synthetic method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V
	@Inject(method = "method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;keyPressed(III)Z"), cancellable = true)
	private static void beforeKeyPressedEvent(int code, class_437 screen, boolean[] resultHack, int key, int scancode, int modifiers, CallbackInfo ci) {
		if (!ScreenKeyboardEvents.allowKeyPress(screen).invoker().allowKeyPress(screen, key, scancode, modifiers)) {
			resultHack[0] = true; // Set this press action as handled.
			ci.cancel(); // Exit the lambda
			return;
		}

		ScreenKeyboardEvents.beforeKeyPress(screen).invoker().beforeKeyPress(screen, key, scancode, modifiers);
	}

	// private synthetic method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V
	@Inject(method = "method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;keyPressed(III)Z", shift = At.Shift.AFTER))
	private static void afterKeyPressedEvent(int code, class_437 screen, boolean[] resultHack, int key, int scancode, int modifiers, CallbackInfo ci) {
		ScreenKeyboardEvents.afterKeyPress(screen).invoker().afterKeyPress(screen, key, scancode, modifiers);
	}

	// private synthetic method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V
	@Inject(method = "method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;keyReleased(III)Z"), cancellable = true)
	private static void beforeKeyReleasedEvent(int code, class_437 screen, boolean[] resultHack, int key, int scancode, int modifiers, CallbackInfo ci) {
		if (!ScreenKeyboardEvents.allowKeyRelease(screen).invoker().allowKeyRelease(screen, key, scancode, modifiers)) {
			resultHack[0] = true; // Set this press action as handled.
			ci.cancel(); // Exit the lambda
			return;
		}

		ScreenKeyboardEvents.beforeKeyRelease(screen).invoker().beforeKeyRelease(screen, key, scancode, modifiers);
	}

	// private synthetic method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V
	@Inject(method = "method_1454(ILnet/minecraft/client/gui/screen/Screen;[ZIII)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;keyReleased(III)Z", shift = At.Shift.AFTER))
	private static void afterKeyReleasedEvent(int code, class_437 screen, boolean[] resultHack, int key, int scancode, int modifiers, CallbackInfo ci) {
		ScreenKeyboardEvents.afterKeyRelease(screen).invoker().afterKeyRelease(screen, key, scancode, modifiers);
	}
}
