/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.tag;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3503;
import net.minecraft.class_3611;

/**
 * Helper methods for registering Tags.
 */
public final class TagRegistry {
	private TagRegistry() { }

	public static <T> class_3494.class_5123<T> create(class_2960 id, Supplier<class_3503<T>> containerSupplier) {
		return new TagDelegate<>(id, containerSupplier);
	}

	public static class_3494<class_2248> block(class_2960 id) {
		return create(id, class_3481::method_15073);
	}

	public static class_3494<class_1299<?>> entityType(class_2960 id) {
		return create(id, class_3483::method_15082);
	}

	public static class_3494<class_3611> fluid(class_2960 id) {
		return create(id, TagRegistry::getFluidTagContainer);
	}

	public static class_3494<class_1792> item(class_2960 id) {
		return create(id, class_3489::method_15106);
	}

	private static Field fluidTagContainer;

	private static class_3503<class_3611> getFluidTagContainer() {
		if (fluidTagContainer == null) {
			for (Field f : class_3486.class.getDeclaredFields()) {
				if ((f.getModifiers() & Modifier.STATIC) != 0 && f.getType() == class_3503.class) {
					f.setAccessible(true);
					fluidTagContainer = f;
					break;
				}
			}

			if (fluidTagContainer == null) {
				throw new RuntimeException("Could not find FluidTags.container!");
			}
		}

		try {
			//noinspection unchecked
			return (class_3503<class_3611>) fluidTagContainer.get(null);
		} catch (IllegalAccessException e) {
			throw new RuntimeException("Could not access FluidTags.container (" + fluidTagContainer.getName() + ")!", e);
		}
	}
}
