/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.tag.extension;

import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.FabricTag;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3503;

public final class TagDelegate<T> implements class_3494.class_5123<T>, FabricTag<T>, FabricTagHooks {
	private final class_2960 id;
	private final Supplier<class_3503<T>> containerSupplier;
	private volatile Target<T> target;
	private int clearCount;

	public TagDelegate(class_2960 id, Supplier<class_3503<T>> containerSupplier) {
		this.id = id;
		this.containerSupplier = containerSupplier;
	}

	@Override
	public boolean method_15141(T var1) {
		return getTag().method_15141(var1);
	}

	@Override
	public List<T> method_15138() {
		return getTag().method_15138();
	}

	/**
	 * Retrieve the tag this delegate is pointing to, computing it if missing or outdated.
	 *
	 * <p>Thread safety is being ensured by using an immutable holder object for consistently retrieving both result
	 * and condition, volatile for safe publishing and assuming TagContainer.getOrCreate is safe to call concurrently.
	 *
	 * <p>It should be possible to exploit a benign data race on this.target by removing volatile, but this option
	 * hasn't been chosen yet since a performance problem in the area is yet to be proven.
	 */
	private class_3494<T> getTag() {
		Target<T> target = this.target;
		class_3503<T> reqContainer = containerSupplier.get();
		class_3494<T> ret;

		if (target == null || target.container != reqContainer) {
			ret = reqContainer.method_15188(method_26791());
			this.target = new Target<>(reqContainer, ret);
		} else {
			ret = target.tag;
		}

		return ret;
	}

	@Override
	public class_2960 method_26791() {
		return id;
	}

	@Override
	public boolean hasBeenReplaced() {
		return clearCount > 0;
	}

	@Override
	public void fabric_setExtraData(int clearCount) {
		this.clearCount = clearCount;
	}

	private static final class Target<T> {
		Target(class_3503<T> container, class_3494<T> tag) {
			this.container = container;
			this.tag = tag;
		}

		final class_3503<T> container;
		final class_3494<T> tag;
	}
}
