/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.texture;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Joiner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.client.texture.DependentSprite;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.impl.client.texture.SpriteRegistryCallbackHolder;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

@Mixin(class_1059.class)
public abstract class MixinSpriteAtlasTexture {
	@Shadow
	public abstract class_2960 method_24106();

	private Map<class_2960, class_1058> fabric_injectedSprites;

	// Loads in custom sprite object injections.
	@Inject(at = @At("RETURN"), method = "loadSprites(Lnet/minecraft/resource/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;")
	private void afterLoadSprites(class_3300 resourceManager_1, Set<class_2960> set_1, CallbackInfoReturnable<Collection<class_1058>> info) {
		if (fabric_injectedSprites != null) {
			info.getReturnValue().addAll(fabric_injectedSprites.values());
			fabric_injectedSprites = null;
		}
	}

	// Handles DependentSprite + custom sprite object injections.
	@ModifyVariable(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/texture/SpriteAtlasTexture;loadSprites(Lnet/minecraft/resource/ResourceManager;Ljava/util/Set;)Ljava/util/Collection;"), method = "stitch")
	public Set<class_2960> beforeSpriteLoad(Set<class_2960> set) {
		fabric_injectedSprites = new HashMap<>();
		ClientSpriteRegistryCallback.Registry registry = new ClientSpriteRegistryCallback.Registry(fabric_injectedSprites, set::add);

		SpriteRegistryCallbackHolder.eventLocal(method_24106()).invoker().registerSprites((class_1059) (Object) this, registry);
		SpriteRegistryCallbackHolder.EVENT_GLOBAL.invoker().registerSprites((class_1059) (Object) this, registry);

		// TODO: Unoptimized.
		Set<DependentSprite> dependentSprites = new HashSet<>();
		Set<class_2960> dependentSpriteIds = new HashSet<>();

		for (class_2960 id : set) {
			class_1058 sprite;

			if ((sprite = fabric_injectedSprites.get(id)) instanceof DependentSprite) {
				dependentSprites.add((DependentSprite) sprite);
				dependentSpriteIds.add(id);
			}
		}

		Set<class_2960> result = set;
		boolean isResultNew = false;

		if (!dependentSprites.isEmpty()) {
			if (!isResultNew) {
				result = new LinkedHashSet<>();
				isResultNew = true;
			}

			for (class_2960 id : set) {
				if (!dependentSpriteIds.contains(id)) {
					result.add(id);
				}
			}

			int lastSpriteSize = 0;

			while (lastSpriteSize != result.size() && result.size() < set.size()) {
				lastSpriteSize = result.size();

				for (DependentSprite sprite : dependentSprites) {
					class_2960 id = ((class_1058) sprite).method_4598();

					if (!result.contains(id) && result.containsAll(sprite.getDependencies())) {
						result.add(id);
					}
				}
			}

			if (result.size() < set.size()) {
				class_128 report = class_128.method_560(new Throwable(), "Resolving sprite dependencies");

				for (DependentSprite sprite : dependentSprites) {
					class_2960 id = ((class_1058) sprite).method_4598();

					if (!result.contains(id)) {
						class_129 element = report.method_562("Unresolved sprite");
						element.method_578("Sprite", id);
						element.method_578("Dependencies", Joiner.on(',').join(sprite.getDependencies()));
					}
				}

				throw new class_148(report);
			}
		}

		if (!fabric_injectedSprites.isEmpty()) {
			if (!isResultNew) {
				result = new LinkedHashSet<>(set);
				isResultNew = true;
			}

			result.removeAll(fabric_injectedSprites.keySet());
		}

		return result;
	}
}
