/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1268;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;

public final class FluidStorageUtil {
    public static boolean interactWithFluidStorage(Storage<FluidVariant> storage, class_1657 player, class_1268 hand) {
        Storage<FluidVariant> handStorage = ContainerItemContext.forPlayerInteraction(player, hand).find(FluidStorage.ITEM);
        if (handStorage == null) {
            return false;
        }
        class_1792 handItem = player.method_5998(hand).method_7909();
        try {
            return FluidStorageUtil.moveWithSound(storage, handStorage, player, true, handItem) || FluidStorageUtil.moveWithSound(handStorage, storage, player, false, handItem);
        }
        catch (Exception e) {
            class_128 report = class_128.method_560((Throwable)e, (String)"Interacting with fluid storage");
            report.method_562("Interaction details").method_577("Player", () -> DebugMessages.forPlayer(player)).method_578("Hand", (Object)hand).method_577("Hand item", () -> ((class_1792)handItem).toString()).method_577("Fluid storage", () -> Objects.toString(storage, null));
            throw new class_148(report);
        }
    }

    private static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, class_1657 player, boolean fill, class_1792 handItem) {
        for (StorageView<FluidVariant> storageView : from) {
            long maxExtracted;
            if (storageView.isResourceBlank()) continue;
            FluidVariant resource = storageView.getResource();
            try (Transaction extractionTestTransaction = Transaction.openOuter();){
                maxExtracted = storageView.extract(resource, Long.MAX_VALUE, extractionTestTransaction);
                extractionTestTransaction.abort();
            }
            Transaction transferTransaction = Transaction.openOuter();
            try {
                class_3414 sound;
                long accepted = to.insert(resource, maxExtracted, transferTransaction);
                if (accepted <= 0L || storageView.extract(resource, accepted, transferTransaction) != accepted) continue;
                transferTransaction.commit();
                class_3414 class_34142 = sound = fill ? FluidVariantAttributes.getFillSound(resource) : FluidVariantAttributes.getEmptySound(resource);
                if (resource.isOf(class_3612.field_15910)) {
                    if (fill && handItem == class_1802.field_8469) {
                        sound = class_3417.field_14779;
                    }
                    if (!fill && handItem == class_1802.field_8574) {
                        sound = class_3417.field_14826;
                    }
                }
                player.method_73183().method_43128((class_1297)player, player.method_23317(), player.method_23320(), player.method_23321(), sound, class_3419.field_15248, 1.0f, 1.0f);
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    private FluidStorageUtil() {
    }
}

