/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.minecraft.class_8886;
import net.minecraft.class_8887;

@Mixin(class_8886.class)
public class CrafterBlockMixin {
	// Inject after vanilla's attempts to insert the stack into an inventory.
	@Inject(method = "transferOrSpawnStack", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", shift = At.Shift.BEFORE))
	private void transferOrSpawnStack(class_3218 world, class_2338 pos, class_8887 blockEntity, class_1799 inputStack, class_2680 state, class_8786<class_3955> recipe, CallbackInfo ci, @Local class_2350 direction, @Local class_1263 inventory, @Local(ordinal = 1) class_1799 itemStack) {
		if (inventory != null) {
			// Vanilla already found and tested an inventory, nothing else to do even if it failed to insert.
			return;
		}

		if (itemStack.method_7960()) {
			// Nothing left to do, in theory should never get here.
			return;
		}

		final Storage<ItemVariant> target = ItemStorage.SIDED.find(world, pos.method_10093(direction), direction.method_10153());

		if (target != null) {
			// Attempt to move the entire stack, and decrement the size of success moves.
			try (Transaction transaction = Transaction.openOuter()) {
				long moved = target.insert(ItemVariant.of(itemStack), inputStack.method_7947(), transaction);

				if (moved > 0) {
					itemStack.method_7934((int) moved);
					transaction.commit();
				}
			}
		}

		// Any remaining will be dropped in the world by vanilla logic
	}
}
