/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApiImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1");
    public static final AtomicLong version = new AtomicLong();
    public static final Storage EMPTY_STORAGE = new Storage(){

        @Override
        public boolean supportsInsertion() {
            return false;
        }

        public long insert(Object resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        @Override
        public boolean supportsExtraction() {
            return false;
        }

        public long extract(Object resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        @Override
        public Iterator<StorageView> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public long getVersion() {
            return 0L;
        }

        public String toString() {
            return "EmptyStorage";
        }
    };

    public static <T> Iterator<T> singletonIterator(final T it) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return it;
            }
        };
    }

    public static <T> List<SingleSlotStorage<T>> makeListView(final SlottedStorage<T> storage) {
        return new AbstractList<SingleSlotStorage<T>>(){

            @Override
            public SingleSlotStorage<T> get(int index) {
                return storage.getSlot(index);
            }

            @Override
            public int size() {
                return storage.getSlotCount();
            }
        };
    }

    public static class_9326 mergeChanges(class_9326 base, class_9326 applied) {
        class_9326.class_9327 builder = class_9326.method_57841();
        TransferApiImpl.writeChangesTo(base, builder);
        TransferApiImpl.writeChangesTo(applied, builder);
        return builder.method_57852();
    }

    private static void writeChangesTo(class_9326 changes, class_9326.class_9327 builder) {
        for (Map.Entry entry : changes.method_57846()) {
            if (((Optional)entry.getValue()).isPresent()) {
                builder.method_57854((class_9331)entry.getKey(), ((Optional)entry.getValue()).get());
                continue;
            }
            builder.method_57853((class_9331)entry.getKey());
        }
    }
}

