/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.mixin.transfer.ItemContainerContentsAccessor;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ContainerComponentStorage
extends CombinedSlottedStorage<ItemVariant, SingleSlotStorage<ItemVariant>> {
    final ContainerItemContext ctx;
    private final Item originalItem;

    public ContainerComponentStorage(ContainerItemContext ctx, int slots) {
        super(Collections.emptyList());
        this.ctx = ctx;
        this.originalItem = ctx.getItemVariant().getItem();
        ArrayList<ContainerSlotWrapper> backingList = new ArrayList<ContainerSlotWrapper>(slots);
        for (int i = 0; i < slots; ++i) {
            backingList.add(new ContainerSlotWrapper(this, i));
        }
        this.parts = Collections.unmodifiableList(backingList);
    }

    ItemContainerContents container() {
        return (ItemContainerContents)this.ctx.getItemVariant().getComponentMap().getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
    }

    ItemContainerContentsAccessor containerAccessor() {
        return (ItemContainerContentsAccessor)this.container();
    }

    private boolean isStillValid() {
        return this.ctx.getItemVariant().getItem() == this.originalItem;
    }

    private class ContainerSlotWrapper
    implements SingleSlotStorage<ItemVariant> {
        final int slot;
        final /* synthetic */ ContainerComponentStorage this$0;

        ContainerSlotWrapper(ContainerComponentStorage containerComponentStorage, int slot) {
            ContainerComponentStorage containerComponentStorage2 = containerComponentStorage;
            Objects.requireNonNull(containerComponentStorage2);
            this.this$0 = containerComponentStorage2;
            this.slot = slot;
        }

        private ItemStack getStack() {
            NonNullList<ItemStack> stacks = this.this$0.containerAccessor().fabric_getStacks();
            if (stacks.size() <= this.slot) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)stacks.get(this.slot);
        }

        protected boolean setStack(ItemStack stack, TransactionContext transaction) {
            List stacks = this.this$0.container().stream().collect(Collectors.toList());
            while (stacks.size() <= this.slot) {
                stacks.add(ItemStack.EMPTY);
            }
            stacks.set(this.slot, stack);
            ContainerItemContext ctx = this.this$0.ctx;
            ItemVariant newVariant = ctx.getItemVariant().withComponentChanges(DataComponentPatch.builder().set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks)).build());
            return ctx.exchange(newVariant, 1L, transaction) == 1L;
        }

        @Override
        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            int insertedAmount;
            StoragePreconditions.notBlankNotNegative(insertedVariant, maxAmount);
            if (!this.this$0.isStillValid()) {
                return 0L;
            }
            ItemStack currentStack = this.getStack();
            if ((insertedVariant.matches(currentStack) || currentStack.isEmpty()) && insertedVariant.getItem().canFitInsideContainerItems() && (insertedAmount = (int)Math.min(maxAmount, this.getCapacity() - (long)currentStack.getCount())) > 0) {
                currentStack = this.getStack().copy();
                if (currentStack.isEmpty()) {
                    currentStack = insertedVariant.toStack(insertedAmount);
                } else {
                    currentStack.grow(insertedAmount);
                }
                if (!this.setStack(currentStack, transaction)) {
                    return 0L;
                }
                return insertedAmount;
            }
            return 0L;
        }

        @Override
        public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
            int extracted;
            StoragePreconditions.notBlankNotNegative(variant, maxAmount);
            if (!this.this$0.isStillValid()) {
                return 0L;
            }
            ItemStack currentStack = this.getStack();
            if (variant.matches(currentStack) && (extracted = (int)Math.min((long)currentStack.getCount(), maxAmount)) > 0) {
                currentStack = this.getStack().copy();
                currentStack.shrink(extracted);
                if (!this.setStack(currentStack, transaction)) {
                    return 0L;
                }
                return extracted;
            }
            return 0L;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getStack().isEmpty();
        }

        @Override
        public ItemVariant getResource() {
            return ItemVariant.of(this.getStack());
        }

        @Override
        public long getAmount() {
            return this.getStack().getCount();
        }

        @Override
        public long getCapacity() {
            return this.getStack().getItem().getDefaultMaxStackSize();
        }

        public String toString() {
            return "ContainerSlotWrapper[%s#%d]".formatted(this.this$0.ctx.getItemVariant(), this.slot);
        }
    }
}

