/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.client.fluid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import org.jspecify.annotations.Nullable;

public final class FluidVariantRendering {
    private static final ApiProviderMap<Fluid, FluidVariantRenderHandler> HANDLERS = ApiProviderMap.create();
    private static final FluidVariantRenderHandler DEFAULT_HANDLER = new FluidVariantRenderHandler(){};

    private FluidVariantRendering() {
    }

    public static void register(Fluid fluid, FluidVariantRenderHandler handler) {
        if (HANDLERS.putIfAbsent((Object)fluid, (Object)handler) != null) {
            throw new IllegalArgumentException("Duplicate handler registration for fluid " + String.valueOf(fluid));
        }
    }

    public static @Nullable FluidVariantRenderHandler getHandler(Fluid fluid) {
        return (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
    }

    public static FluidVariantRenderHandler getHandlerOrDefault(Fluid fluid) {
        FluidVariantRenderHandler handler = (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
        return handler == null ? DEFAULT_HANDLER : handler;
    }

    public static List<Component> getTooltip(FluidVariant fluidVariant) {
        return FluidVariantRendering.getTooltip(fluidVariant, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }

    public static List<Component> getTooltip(FluidVariant fluidVariant, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(FluidVariantAttributes.getName(fluidVariant));
        FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).appendTooltip(fluidVariant, tooltip, flag);
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fluidVariant.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public static @Nullable TextureAtlasSprite[] getSprites(FluidVariant fluidVariant) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getSprites(fluidVariant);
    }

    public static @Nullable TextureAtlasSprite getSprite(FluidVariant fluidVariant) {
        TextureAtlasSprite[] sprites = FluidVariantRendering.getSprites(fluidVariant);
        return sprites != null ? Objects.requireNonNull(sprites[0]) : null;
    }

    public static int getColor(FluidVariant fluidVariant) {
        return FluidVariantRendering.getColor(fluidVariant, null, null);
    }

    public static int getColor(FluidVariant fluidVariant, @Nullable BlockAndTintGetter view, @Nullable BlockPos pos) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getColor(fluidVariant, view, pos);
    }
}

