/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;

public interface FabricModJsonSource {
    public byte[] read(String var1) throws IOException;

    public record SourceSetSource(Project project, SourceSet[] sourceSets) implements FabricModJsonSource
    {
        @Override
        public byte[] read(String path) throws IOException {
            return Files.readAllBytes(this.findFile(path).toPath());
        }

        private File findFile(String path) throws IOException {
            File file = SourceSetHelper.findFirstFileInResource(path, this.project, this.sourceSets);
            if (file == null) {
                throw new FileNotFoundException("Could not find: " + path);
            }
            return file;
        }
    }

    public record DirectorySource(Path directoryPath) implements FabricModJsonSource
    {
        @Override
        public byte[] read(String path) throws IOException {
            return Files.readAllBytes(this.directoryPath.resolve(path));
        }
    }

    public record ZipSource(Path zipPath) implements FabricModJsonSource
    {
        @Override
        public byte[] read(String path) throws IOException {
            return ZipUtils.unpack(this.zipPath, path);
        }
    }
}

