/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Usage;

public interface SpecContextProjectView {
    public LoomGradleExtension extension();

    public Stream<Project> getLoomProjectDependencies(String var1);

    public Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(boolean var1);

    public List<FabricModJson> getMods();

    public boolean disableProjectDependantMods();

    public record Impl(Project project, LoomGradleExtension extension) implements SpecContextProjectView
    {
        @Override
        public Stream<Project> getLoomProjectDependencies(String name) {
            Configuration configuration = this.project.getConfigurations().getByName(name);
            return configuration.getAllDependencies().withType(ProjectDependency.class).stream().map(d -> this.project.project(d.getPath())).filter(GradleUtils::isLoomProject);
        }

        @Override
        public Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(boolean runtime) {
            Usage usage = (Usage)this.project.getObjects().named(Usage.class, runtime ? "java-runtime" : "java-api");
            return settings -> {
                Configuration configuration = ((Configuration)settings.getSourceConfiguration().get()).copyRecursive();
                configuration.setCanBeConsumed(false);
                configuration.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
                return configuration.resolve().stream().map(File::toPath);
            };
        }

        @Override
        public List<FabricModJson> getMods() {
            return FabricModJsonHelpers.getModsInProject(this.project);
        }

        @Override
        public boolean disableProjectDependantMods() {
            LoomGradleExtension extension = LoomGradleExtension.get(this.project);
            return extension.isProjectIsolationActive() || GradleUtils.getBooleanProperty(this.project, "fabric.loom.disableProjectDependentMods");
        }
    }
}

