/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.GenericAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrRemapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record MethodAnnotationData(@SerializedName(value="remove") Set<String> annotationsToRemove, @SerializedName(value="add") List<AnnotationNode> annotationsToAdd, @SerializedName(value="type_remove") Set<TypeAnnotationKey> typeAnnotationsToRemove, @SerializedName(value="type_add") List<TypeAnnotationNode> typeAnnotationsToAdd, Map<Integer, GenericAnnotationData> parameters) {
    public MethodAnnotationData {
        if (annotationsToRemove == null) {
            annotationsToRemove = new LinkedHashSet<String>();
        }
        if (annotationsToAdd == null) {
            annotationsToAdd = new ArrayList<AnnotationNode>();
        }
        if (typeAnnotationsToRemove == null) {
            typeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>();
        }
        if (typeAnnotationsToAdd == null) {
            typeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>();
        }
        if (parameters == null) {
            parameters = new LinkedHashMap<Integer, GenericAnnotationData>();
        }
    }

    MethodAnnotationData merge(MethodAnnotationData other) {
        LinkedHashSet<String> newAnnotationsToRemove = new LinkedHashSet<String>(this.annotationsToRemove);
        newAnnotationsToRemove.addAll(other.annotationsToRemove);
        ArrayList<AnnotationNode> newAnnotationsToAdd = new ArrayList<AnnotationNode>(this.annotationsToAdd);
        newAnnotationsToAdd.addAll(other.annotationsToAdd);
        LinkedHashSet<TypeAnnotationKey> newTypeAnnotationsToRemove = new LinkedHashSet<TypeAnnotationKey>(this.typeAnnotationsToRemove);
        newTypeAnnotationsToRemove.addAll(other.typeAnnotationsToRemove);
        ArrayList<TypeAnnotationNode> newTypeAnnotationsToAdd = new ArrayList<TypeAnnotationNode>(this.typeAnnotationsToAdd);
        newTypeAnnotationsToAdd.addAll(other.typeAnnotationsToAdd);
        LinkedHashMap<Integer, GenericAnnotationData> newParameters = new LinkedHashMap<Integer, GenericAnnotationData>(this.parameters);
        other.parameters.forEach((key, value) -> newParameters.merge((Integer)key, (GenericAnnotationData)value, GenericAnnotationData::merge));
        return new MethodAnnotationData(newAnnotationsToRemove, newAnnotationsToAdd, newTypeAnnotationsToRemove, newTypeAnnotationsToAdd, newParameters);
    }

    MethodAnnotationData remap(TinyRemapper remapper) {
        return new MethodAnnotationData(this.annotationsToRemove.stream().map(arg_0 -> ((TrRemapper)remapper.getEnvironment().getRemapper()).map(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new)), this.annotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)), this.typeAnnotationsToRemove.stream().map(key -> key.remap(remapper)).collect(Collectors.toCollection(LinkedHashSet::new)), this.typeAnnotationsToAdd.stream().map(ann -> AnnotationsData.remap(ann, remapper)).collect(Collectors.toCollection(ArrayList::new)), AnnotationsData.remapMap(this.parameters, Map.Entry::getKey, entry -> ((GenericAnnotationData)entry.getValue()).remap(remapper)));
    }

    public int modifyAccessFlags(int access) {
        if (this.annotationsToRemove.contains("java/lang/Deprecated")) {
            access &= 0xFFFDFFFF;
        }
        if (this.annotationsToAdd.stream().anyMatch(ann -> "Ljava/lang/Deprecated;".equals(ann.desc))) {
            access |= 0x20000;
        }
        return access;
    }
}

