/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.xml.sax.InputSource;

public final class SourceSetHelper {
    @VisibleForTesting
    @Language(value="xpath")
    public static final String IDEA_OUTPUT_XPATH = "/project/component[@name='ProjectRootManager']/output/@url";

    private SourceSetHelper() {
    }

    public static SourceSetContainer getSourceSets(Project project) {
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return javaExtension.getSourceSets();
    }

    public static boolean isSourceSetOfProject(SourceSet sourceSet, Project project) {
        if (System.getProperty("fabric-loom.unit.testing") != null) {
            return true;
        }
        return SourceSetHelper.getSourceSets(project).stream().anyMatch(test -> test == sourceSet);
    }

    public static SourceSet getSourceSetByName(String name, Project project) {
        return (SourceSet)SourceSetHelper.getSourceSets(project).getByName(name);
    }

    public static SourceSet getMainSourceSet(Project project) {
        return SourceSetHelper.getSourceSetByName("main", project);
    }

    public static SourceSet createSourceSet(String name, Project project) {
        return (SourceSet)SourceSetHelper.getSourceSets(project).create(name);
    }

    public static Project getSourceSetProject(SourceSet sourceSet) {
        Project project = SourceSetHelper.getProjectFromSourceSetOutput(sourceSet.getOutput());
        if (project == null) {
            throw new NullPointerException("Unable to determine owning project for SourceSet: " + sourceSet.getName());
        }
        return project;
    }

    @Nullable
    private static Project getProjectFromSourceSetOutput(SourceSetOutput sourceSetOutput) {
        Set dependencies = sourceSetOutput.getBuildDependencies().getDependencies(null);
        Iterator it = dependencies.iterator();
        return it.hasNext() ? ((Task)it.next()).getProject() : null;
    }

    public static List<File> getClasspath(SourceSetReference reference, boolean forExport) {
        Project project = reference.project();
        List<File> classpath = SourceSetHelper.getGradleClasspath(reference, forExport);
        classpath.addAll(SourceSetHelper.getIdeaClasspath(reference, project));
        classpath.addAll(SourceSetHelper.getIdeaModuleCompileOutput(reference));
        classpath.addAll(SourceSetHelper.getEclipseClasspath(reference, project));
        classpath.addAll(SourceSetHelper.getVscodeClasspath(reference, project));
        return classpath;
    }

    private static List<File> getGradleClasspath(SourceSetReference reference, boolean forExport) {
        SourceSetOutput output = reference.sourceSet().getOutput();
        File resources = output.getResourcesDir();
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.addAll(output.getClassesDirs().getFiles());
        if (resources != null) {
            classpath.add(resources);
        }
        if (forExport && "main".equals(reference.sourceSet().getName()) && GradleUtils.isLoomProject(reference.project())) {
            Configuration namedElements = reference.project().getConfigurations().getByName("namedElements");
            for (File artifact : namedElements.getOutgoing().getArtifacts().getFiles()) {
                classpath.add(artifact);
            }
        }
        return classpath;
    }

    @VisibleForTesting
    public static List<File> getIdeaClasspath(SourceSetReference reference, Project project) {
        File projectDir = project.getRootDir();
        File dotIdea = new File(projectDir, ".idea");
        if (!dotIdea.exists()) {
            return Collections.emptyList();
        }
        File miscXml = new File(dotIdea, "misc.xml");
        if (!miscXml.exists()) {
            return Collections.emptyList();
        }
        String outputDirUrl = SourceSetHelper.evaluateXpath(miscXml, IDEA_OUTPUT_XPATH);
        if (outputDirUrl == null) {
            return Collections.emptyList();
        }
        outputDirUrl = outputDirUrl.replace("$PROJECT_DIR$", projectDir.getAbsolutePath());
        outputDirUrl = outputDirUrl.replaceAll("^file:", "");
        File productionDir = new File(outputDirUrl, "production");
        File outputDir = new File(productionDir, IdeaUtils.getIdeaModuleName(reference));
        return Collections.singletonList(outputDir);
    }

    private static List<File> getIdeaModuleCompileOutput(SourceSetReference reference) {
        File dotIdea = new File(reference.project().getRootDir(), ".idea");
        if (!dotIdea.exists()) {
            return Collections.emptyList();
        }
        String name = reference.sourceSet().getName();
        File projectDir = reference.project().getProjectDir();
        File outDir = new File(projectDir, "out");
        File sourceSetOutDir = new File(outDir, name.equals("main") ? "production" : name);
        return List.of(new File(sourceSetOutDir, "classes"), new File(sourceSetOutDir, "resources"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String evaluateXpath(File file, @Language(value="xpath") String expression) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try (FileInputStream fis = new FileInputStream(file);){
            String result = xpath.evaluate(expression, new InputSource(fis));
            if (result.isEmpty()) {
                String string = null;
                return string;
            }
            String string = result;
            return string;
        }
        catch (XPathExpressionException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    public static List<File> getEclipseClasspath(SourceSetReference reference, Project project) {
        File projectDir = project.getProjectDir();
        File classpath = new File(projectDir, ".classpath");
        if (!classpath.exists()) {
            return Collections.emptyList();
        }
        return SourceSetHelper.getBinDirClasspath(projectDir, reference);
    }

    @VisibleForTesting
    public static List<File> getVscodeClasspath(SourceSetReference reference, Project project) {
        File projectDir = project.getProjectDir();
        File dotVscode = new File(projectDir, ".vscode");
        if (!dotVscode.exists()) {
            return Collections.emptyList();
        }
        return SourceSetHelper.getBinDirClasspath(projectDir, reference);
    }

    private static List<File> getBinDirClasspath(File projectDir, SourceSetReference reference) {
        File binDir = new File(projectDir, "bin");
        if (!binDir.exists()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new File(binDir, reference.sourceSet().getName()));
    }

    @Nullable
    public static File findFileInResource(Project project, SourceSet sourceSet, String path) {
        Objects.requireNonNull(project);
        Objects.requireNonNull(sourceSet);
        Objects.requireNonNull(path);
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.isConfigurationCacheActive()) {
            for (File rootDir : sourceSet.getResources().getSrcDirs()) {
                File file = GradleUtils.configurationInputFile(project, new File(rootDir, path));
                if (!file.exists()) continue;
                return file;
            }
            return null;
        }
        try {
            return sourceSet.getResources().matching(patternFilterable -> patternFilterable.include(new String[]{path})).getSingleFile();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Nullable
    public static File findFirstFileInResource(String path, Project project, SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            File file = SourceSetHelper.findFileInResource(project, sourceSet, path);
            if (file == null) continue;
            return file;
        }
        return null;
    }
}

