/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library.processors;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.artifacts.dsl.RepositoryHandler;

public class LWJGL3UpgradeLibraryProcessor
extends LibraryProcessor {
    private static final String LWJGL_GROUP = "org.lwjgl";
    private static final String LWJGL_VERSION = "3.3.2";
    private static final String LWJGL_VERSION_RISCV = "3.3.4";

    public LWJGL3UpgradeLibraryProcessor(Platform platform, LibraryContext context) {
        super(platform, context);
    }

    @Override
    public LibraryProcessor.ApplicationResult getApplicationResult() {
        if (!this.context.usesLWJGL3()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        if (this.context.isJava19OrLater() && !this.context.supportsJava19OrLater()) {
            return LibraryProcessor.ApplicationResult.MUST_APPLY;
        }
        if (this.upgradeMacOSArm()) {
            return LibraryProcessor.ApplicationResult.MUST_APPLY;
        }
        if (this.upgradeLinuxRiscV()) {
            if (!this.context.hasClasspathNatives()) {
                return LibraryProcessor.ApplicationResult.DONT_APPLY;
            }
            return LibraryProcessor.ApplicationResult.MUST_APPLY;
        }
        return LibraryProcessor.ApplicationResult.CAN_APPLY;
    }

    @Override
    public Predicate<Library> apply(Consumer<Library> dependencyConsumer) {
        String version = this.upgradeLinuxRiscV() ? LWJGL_VERSION_RISCV : LWJGL_VERSION;
        return library -> {
            if (library.is(LWJGL_GROUP) && library.name().startsWith("lwjgl")) {
                Library.Target target = library.target() == Library.Target.NATIVES ? Library.Target.NATIVES : Library.Target.RUNTIME;
                Library upgradedLibrary = library.withVersion(version).withTarget(target);
                dependencyConsumer.accept(upgradedLibrary);
            }
            return true;
        };
    }

    @Override
    public void applyRepositories(RepositoryHandler repositories) {
        LoomRepositoryPlugin.forceLWJGLFromMavenCentral(repositories);
    }

    private boolean upgradeMacOSArm() {
        return this.platform.getOperatingSystem().isMacOS() && this.platform.getArchitecture().isArm() && !this.context.supportsArm64(Platform.OperatingSystem.MAC_OS) && !this.context.hasClasspathNatives();
    }

    private boolean upgradeLinuxRiscV() {
        return this.platform.getOperatingSystem().isLinux() && this.platform.getArchitecture().isRiscV() && this.platform.getArchitecture().is64Bit();
    }
}

