/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.api.fmj.FabricModJsonV1Spec;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.fmj.gen.FabricModJsonV1Generator;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class FabricModJsonV1Task
extends AbstractLoomTask {
    @Nested
    public abstract Property<FabricModJsonV1Spec> getJson();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public FabricModJsonV1Task() {
        this.getJson().set((Object)((FabricModJsonV1Spec)this.getObjectFactory().newInstance(FabricModJsonV1Spec.class, new Object[0])));
    }

    public void json(Action<FabricModJsonV1Spec> action) {
        action.execute((Object)((FabricModJsonV1Spec)this.getJson().get()));
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(FabricModJsonV1WorkAction.class, params -> {
            params.getSpec().set(this.getJson());
            params.getOutputFile().set((Provider)this.getOutputFile());
        });
    }

    public static abstract class FabricModJsonV1WorkAction
    implements WorkAction<FabricModJsonV1WorkParameters> {
        public void execute() {
            FabricModJsonV1Spec spec = (FabricModJsonV1Spec)((FabricModJsonV1WorkParameters)this.getParameters()).getSpec().get();
            Path outputPath = ((RegularFile)((FabricModJsonV1WorkParameters)this.getParameters()).getOutputFile().get()).getAsFile().toPath();
            String json = FabricModJsonV1Generator.INSTANCE.generate(spec);
            try {
                Files.writeString(outputPath, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write fabric.mod.json", e);
            }
        }
    }

    public static interface FabricModJsonV1WorkParameters
    extends WorkParameters {
        public Property<FabricModJsonV1Spec> getSpec();

        public RegularFileProperty getOutputFile();
    }
}

