/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.task.DownloadAssetsTask;
import net.fabricmc.loom.task.DownloadTask;
import net.fabricmc.loom.task.ExtractNativesTask;
import net.fabricmc.loom.task.GenEclipseRunsTask;
import net.fabricmc.loom.task.GenVsCodeProjectTask;
import net.fabricmc.loom.task.MigrateClassTweakerMappingsTask;
import net.fabricmc.loom.task.MigrateMappingsTask;
import net.fabricmc.loom.task.RenderDocRunTask;
import net.fabricmc.loom.task.RenderDocRunUITask;
import net.fabricmc.loom.task.RunGameTask;
import net.fabricmc.loom.task.ValidateAccessWidenerTask;
import net.fabricmc.loom.task.launch.GenerateDLIConfigTask;
import net.fabricmc.loom.task.launch.GenerateLog4jConfigTask;
import net.fabricmc.loom.task.launch.GenerateRemapClasspathTask;
import net.fabricmc.loom.util.Check;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;

public abstract class LoomTasks
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract TaskContainer getTasks();

    @Override
    public void run() {
        SourceSetHelper.getSourceSets(this.getProject()).all(sourceSet -> {
            if (SourceSetHelper.isMainSourceSet(sourceSet)) {
                this.getTasks().register("migrateMappings", MigrateMappingsTask.class, t -> t.setDescription("Migrates source code mappings to a new version."));
                return;
            }
            if (!SourceSetHelper.getFirstSrcDir(sourceSet).exists()) {
                return;
            }
            this.getTasks().register(sourceSet.getTaskName("migrate", "mappings"), MigrateMappingsTask.class, t -> {
                t.setDescription("Migrates source code mappings to a new version.");
                t.getInputDir().set(SourceSetHelper.getFirstSrcDir(sourceSet));
                t.getOutputDir().convention(this.getProject().getLayout().getProjectDirectory().dir(sourceSet.getTaskName("remapped", "src")));
            });
        });
        this.getTasks().register("migrateClassTweakerMappings", MigrateClassTweakerMappingsTask.class, t -> t.setDescription("Migrates access widener and class tweaker mappings to a new version."));
        TaskProvider generateLog4jConfig = this.getTasks().register("generateLog4jConfig", GenerateLog4jConfigTask.class, t -> t.setDescription("Generate the log4j config file"));
        TaskProvider generateRemapClasspath = this.getTasks().register("generateRemapClasspath", GenerateRemapClasspathTask.class, t -> t.setDescription("Generate the remap classpath file"));
        this.getTasks().register("generateDLIConfig", GenerateDLIConfigTask.class, t -> {
            t.setDescription("Generate the DevLaunchInjector config file");
            t.mustRunAfter(new Object[]{"eclipse"});
            t.dependsOn(new Object[]{generateLog4jConfig});
            t.getRemapClasspathFile().set((Provider)((GenerateRemapClasspathTask)((Object)((Object)generateRemapClasspath.get()))).getRemapClasspathFile());
        });
        this.getTasks().register("configureLaunch", task -> {
            task.dependsOn(new Object[]{this.getTasks().named("generateDLIConfig")});
            task.dependsOn(new Object[]{this.getTasks().named("generateLog4jConfig")});
            task.dependsOn(new Object[]{this.getTasks().named("generateRemapClasspath")});
            task.setDescription("Setup the required files to launch Minecraft");
            task.setGroup("fabric");
        });
        TaskProvider validateAccessWidener = this.getTasks().register("validateAccessWidener", ValidateAccessWidenerTask.class, t -> {
            t.setDescription("Validate all the rules in the access widener against the Minecraft jar");
            t.setGroup("verification");
        });
        this.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{validateAccessWidener}));
        this.registerIDETasks();
        this.registerRunTasks();
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
            if (extension.getMinecraftJarConfiguration().get() == MinecraftJarConfiguration.SERVER_ONLY) {
                return;
            }
            MinecraftVersionMeta versionInfo = extension.getMinecraftProvider().getVersionInfo();
            if (versionInfo == null) {
                return;
            }
            LoomTasks.registerClientSetupTasks(this.getTasks(), versionInfo.hasNativesToExtract());
        });
    }

    private void registerIDETasks() {
        this.getTasks().register("genEclipseRuns", GenEclipseRunsTask.class, t -> {
            t.setDescription("Generates Eclipse run configurations for this project.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            t.setGroup("ide");
        });
        this.getTasks().register("vscode", GenVsCodeProjectTask.class, t -> {
            t.setDescription("Generates VSCode launch configurations.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            t.setGroup("ide");
        });
    }

    public static String getRunConfigTaskName(RunConfigSettings config) {
        String configName = config.getName();
        return "run" + configName.substring(0, 1).toUpperCase() + configName.substring(1);
    }

    private void registerRunTasks() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        boolean renderDocSupported = RenderDocRunTask.isSupported(Platform.CURRENT);
        Check.require(extension.getRunConfigs().isEmpty(), "Run configurations must not be registered before loom");
        extension.getRunConfigs().whenObjectAdded(config -> {
            TaskProvider runTask = this.getTasks().register(LoomTasks.getRunConfigTaskName(config), RunGameTask.class, new Object[]{config});
            runTask.configure(t -> {
                t.setDescription("Starts the '" + config.getConfigName() + "' run configuration");
                t.dependsOn(new Object[]{config.getEnvironment().equals("client") ? "configureClientLaunch" : "configureLaunch"});
            });
            if (config.getName().equals("client") && renderDocSupported) {
                this.getTasks().register("runClientRenderDoc", RenderDocRunTask.class, new Object[]{config});
            }
        });
        if (renderDocSupported) {
            this.configureRenderDocTasks();
        }
        extension.getRunConfigs().whenObjectRemoved(runConfigSettings -> this.getTasks().named(LoomTasks.getRunConfigTaskName(runConfigSettings), task -> task.setEnabled(false)));
        extension.getRunConfigs().create("client", RunConfigSettings::client);
        extension.getRunConfigs().create("server", RunConfigSettings::server);
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            String taskName;
            boolean clientOnly;
            boolean serverOnly = extension.getMinecraftJarConfiguration().get() == MinecraftJarConfiguration.SERVER_ONLY;
            boolean bl = clientOnly = extension.getMinecraftJarConfiguration().get() == MinecraftJarConfiguration.CLIENT_ONLY;
            if (serverOnly) {
                taskName = "client";
            } else if (clientOnly) {
                taskName = "server";
            } else {
                return;
            }
            extension.getRunConfigs().removeIf(settings -> settings.getName().equals(taskName) || settings.getName().equals(taskName + "RenderDoc"));
        });
    }

    private void configureRenderDocTasks() {
        Platform.OperatingSystem operatingSystem = Platform.CURRENT.getOperatingSystem();
        String renderDocVersion = LoomVersions.RENDERDOC.version();
        String renderDocBaseName = operatingSystem.isWindows() ? "RenderDoc_%s_64".formatted(renderDocVersion) : "renderdoc_%s".formatted(renderDocVersion);
        String renderDocFilename = operatingSystem.isWindows() ? "%s.zip".formatted(renderDocBaseName) : "%s.tar.gz".formatted(renderDocBaseName);
        String renderDocUrl = "https://maven.fabricmc.net/org/renderdoc/%s".formatted(renderDocFilename);
        String executableExt = operatingSystem.isWindows() ? ".exe" : "";
        TaskProvider downloadRenderDoc = this.getTasks().register("downloadRenderDoc", DownloadTask.class, task -> {
            task.setGroup("fabric");
            task.getUrl().set((Object)renderDocUrl);
            task.getOutput().set(this.getProject().getLayout().getBuildDirectory().file(renderDocFilename));
        });
        TaskProvider extractRenderDoc = this.getTasks().register("extractRenderDoc", Sync.class, task -> {
            task.setGroup("fabric");
            if (operatingSystem.isWindows()) {
                task.from(new Object[]{this.getProject().zipTree((Object)downloadRenderDoc.flatMap(DownloadTask::getOutput))});
            } else {
                task.from(new Object[]{this.getProject().tarTree((Object)downloadRenderDoc.flatMap(DownloadTask::getOutput))});
            }
            task.into((Object)this.getProject().getLayout().getBuildDirectory().dir("renderdoc"));
        });
        Provider renderDocDir = extractRenderDoc.map(DefaultTask::getOutputs).map(TaskOutputs::getFiles).map(FileCollection::getSingleFile).map(dir -> new File((File)dir, renderDocBaseName));
        if (operatingSystem.isLinux()) {
            renderDocDir = renderDocDir.map(dir -> new File((File)dir, "bin"));
        }
        Provider renderDocCMD = renderDocDir.map(dir -> new File((File)dir, "renderdoccmd" + executableExt));
        Provider renderDocUI = renderDocDir.map(dir -> new File((File)dir, "qrenderdoc" + executableExt));
        this.getTasks().register("startRenderDocUI", RenderDocRunUITask.class, task -> task.getRenderDocExecutable().fileProvider(renderDocUI));
        this.getTasks().withType(RenderDocRunTask.class).configureEach(task -> task.getRenderDocExecutable().fileProvider(renderDocCMD));
    }

    private static void registerClientSetupTasks(TaskContainer tasks, boolean extractNatives) {
        tasks.register("downloadAssets", DownloadAssetsTask.class, t -> t.setDescription("Downloads required game assets for Minecraft."));
        if (extractNatives) {
            tasks.register("extractNatives", ExtractNativesTask.class, t -> t.setDescription("Extracts the Minecraft platform specific natives."));
        }
        tasks.register("configureClientLaunch", task -> {
            task.dependsOn(new Object[]{tasks.named("downloadAssets")});
            task.dependsOn(new Object[]{tasks.named("configureLaunch")});
            if (extractNatives) {
                task.dependsOn(new Object[]{tasks.named("extractNatives")});
            }
            task.setDescription("Setup the required files to launch the Minecraft client");
            task.setGroup("fabric");
        });
    }

    public static Provider<Task> getIDELaunchConfigureTaskName(Project project) {
        return project.provider(() -> {
            MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)LoomGradleExtension.get(project).getMinecraftJarConfiguration().get();
            String name = jarConfiguration == MinecraftJarConfiguration.SERVER_ONLY ? "configureLaunch" : "configureClientLaunch";
            return project.getTasks().getByName(name);
        });
    }
}

