/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.loom.util.download.DownloadProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.jetbrains.annotations.Nullable;

public class GradleDownloadProgressListener
implements DownloadProgressListener {
    private final String name;
    private final Function<String, ProgressLogger> progressLoggerFactory;
    @Nullable
    private ProgressLogger progressLogger;

    public GradleDownloadProgressListener(String name, Function<String, ProgressLogger> progressLoggerFactory) {
        this.name = name;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public void onStart() {
        this.progressLogger = this.progressLoggerFactory.apply(this.name);
    }

    @Override
    public void onProgress(long bytesTransferred, long contentLength) {
        Objects.requireNonNull(this.progressLogger);
        this.progressLogger.progress("Downloading %s - %s / %s".formatted(this.name, GradleDownloadProgressListener.humanBytes(bytesTransferred), GradleDownloadProgressListener.humanBytes(contentLength)));
    }

    @Override
    public void onEnd() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
            this.progressLogger = null;
        }
    }

    private static String humanBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }
}

