/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.classpathgroups;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroup;

public record ClasspathGroup(List<String> paths, List<ExternalClasspathGroup> externalGroups) implements Serializable
{
    public ClasspathGroup(List<String> paths, List<ExternalClasspathGroup> externalGroups) {
        this.paths = new ArrayList<String>(paths);
        this.externalGroups = new ArrayList<ExternalClasspathGroup>(externalGroups);
    }

    public static List<ClasspathGroup> fromModSettings(Set<ModSettings> modSettings) {
        return modSettings.stream().map(s -> new ClasspathGroup(ClasspathGroup.getPaths(s), (List)s.getExternalGroups().get())).toList();
    }

    private static List<String> getPaths(ModSettings modSettings) {
        return modSettings.getModFiles().getFiles().stream().map(File::getAbsolutePath).toList();
    }
}

