/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.nesting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.util.Check;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.slf4j.Logger;

public class JarNester {
    public static void nestJars(Collection<File> jars, File modJar, Logger logger) {
        if (jars.isEmpty()) {
            logger.debug("Nothing to nest into " + modJar.getName());
            return;
        }
        Check.require(FabricModJsonFactory.isModJar(modJar), "Cannot nest jars into none mod jar " + modJar.getName());
        List<File> sortedJars = jars.stream().sorted(Comparator.comparing(File::getName)).toList();
        try {
            ZipUtils.add(modJar.toPath(), sortedJars.stream().map(file -> {
                try {
                    return new Pair<CallSite, byte[]>((CallSite)((Object)("META-INF/jars/" + file.getName())), Files.readAllBytes(file.toPath()));
                }
                catch (IOException e) {
                    throw new org.gradle.api.UncheckedIOException((Throwable)e);
                }
            }).collect(Collectors.toList()));
            int count = ZipUtils.transformJson(JsonObject.class, modJar.toPath(), Stream.of(new Pair<String, ZipUtils.UnsafeUnaryOperator<JsonObject>>("fabric.mod.json", json -> {
                JsonArray nestedJars = json.getAsJsonArray("jars");
                if (nestedJars == null || !json.has("jars")) {
                    nestedJars = new JsonArray();
                }
                for (File file : sortedJars) {
                    String nestedJarPath = "META-INF/jars/" + file.getName();
                    Check.require(FabricModJsonFactory.isModJar(file), "Cannot nest none mod jar: " + file.getName());
                    for (JsonElement nestedJar : nestedJars) {
                        JsonObject jsonObject = nestedJar.getAsJsonObject();
                        if (!jsonObject.has("file") || !jsonObject.get("file").getAsString().equals(nestedJarPath)) continue;
                        throw new IllegalStateException("Cannot nest 2 jars at the same path: " + nestedJarPath);
                    }
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("file", nestedJarPath);
                    nestedJars.add((JsonElement)jsonObject);
                    logger.debug("Nested " + nestedJarPath + " into " + modJar.getName());
                }
                json.add("jars", (JsonElement)nestedJars);
                return json;
            })));
            Check.require(count > 0, "Failed to transform fabric.mod.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to nest jars into " + modJar.getName(), e);
        }
    }
}

