/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.FileSpec;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;

public record DependencyFileSpec(Dependency dependency) implements FileSpec
{
    @Override
    public Path get(MappingContext context) {
        Dependency dependency = this.dependency;
        if (dependency instanceof FileCollectionDependency) {
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            Set files = fileCollectionDependency.getFiles().getFiles();
            if (files.isEmpty()) {
                throw new RuntimeException("FileCollectionDependency (%s) resolved no files".formatted(fileCollectionDependency.toString()));
            }
            if (files.size() > 1) {
                throw new RuntimeException("FileCollectionDependency (%s) resolved too many files (%d) only 1 is expected".formatted(fileCollectionDependency.toString(), files.size()));
            }
            return ((File)files.iterator().next()).toPath();
        }
        return context.resolveDependency(this.dependency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dependency.getGroup(), this.dependency.getName(), this.dependency.getVersion());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DependencyFileSpec) {
            DependencyFileSpec other = (DependencyFileSpec)obj;
            return other.dependency().contentEquals(this.dependency());
        }
        return false;
    }
}

