/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonV1;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Experimental
public final class FabricModJsonV2
extends FabricModJson {
    FabricModJsonV2(JsonObject jsonObject, FabricModJsonSource source) {
        super(jsonObject, source);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public @Nullable JsonElement getCustom(String key) {
        return FabricModJsonV1.getCustom(this.jsonObject, key);
    }

    @Override
    public List<String> getMixinConfigurations() {
        if (!this.jsonObject.has("mixins")) {
            return Collections.emptyList();
        }
        return List.copyOf(this.getConditionalConfigs(this.jsonObject.get("mixins")).keySet());
    }

    @Override
    public Map<String, ModEnvironment> getClassTweakers() {
        if (!this.jsonObject.has("classTweakers")) {
            return Collections.emptyMap();
        }
        return this.getConditionalConfigs(this.jsonObject.get("classTweakers"));
    }

    private Map<String, ModEnvironment> getConditionalConfigs(JsonElement jsonElement) {
        JsonPrimitive jsonPrimitive;
        HashMap<String, ModEnvironment> values = new HashMap<String, ModEnvironment>();
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            for (JsonElement arrayElement : jsonArray) {
                Pair<String, ModEnvironment> value = this.readConditionalConfig(arrayElement);
                if (value == null) continue;
                values.put(value.left(), value.right());
            }
        } else if (jsonElement instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement).isString()) {
            Pair<String, ModEnvironment> value = this.readConditionalConfig((JsonElement)jsonPrimitive);
            if (value != null) {
                values.put(value.left(), value.right());
            }
        } else {
            throw new FabricModJsonUtils.ParseException("Must be a string or array of strings", new Object[0]);
        }
        return values;
    }

    private @Nullable Pair<String, ModEnvironment> readConditionalConfig(JsonElement jsonElement) {
        JsonPrimitive jsonPrimitive;
        if (jsonElement instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement).isString()) {
            return new Pair<String, ModEnvironment>(jsonElement.getAsString(), ModEnvironment.UNIVERSAL);
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            String config = FabricModJsonUtils.readString(jsonObject, "config");
            return new Pair<String, ModEnvironment>(config, this.getEnvironment(jsonObject));
        }
        throw new FabricModJsonUtils.ParseException("Must be a string or an object", new Object[0]);
    }

    private ModEnvironment getEnvironment(JsonObject jsonObject) {
        String environment;
        JsonPrimitive jsonPrimitive;
        if (!jsonObject.has("environment")) {
            return ModEnvironment.UNIVERSAL;
        }
        JsonElement jsonElement = jsonObject.get("environment");
        if (!(jsonElement instanceof JsonPrimitive) || !(jsonPrimitive = (JsonPrimitive)jsonElement).isString()) {
            throw new FabricModJsonUtils.ParseException("Environment must be a string", new Object[0]);
        }
        return switch (environment = jsonPrimitive.getAsString()) {
            case "*" -> ModEnvironment.UNIVERSAL;
            case "client" -> ModEnvironment.CLIENT;
            case "server" -> ModEnvironment.SERVER;
            default -> throw new FabricModJsonUtils.ParseException("Invalid environment type: " + environment, new Object[0]);
        };
    }
}

