/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.verify;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.loom.configuration.providers.minecraft.verify.JarVerifier;
import net.fabricmc.loom.configuration.providers.minecraft.verify.SignatureVerificationFailure;
import org.jspecify.annotations.Nullable;

public interface CertificateChain {
    public X509Certificate certificate();

    public @Nullable CertificateChain issuer();

    public List<CertificateChain> children();

    public void verifyChainMatches(CertificateChain var1) throws SignatureVerificationFailure;

    public static void visitAll(CertificateChain chain, CertificateConsumer consumer) throws SignatureVerificationFailure {
        consumer.accept(chain.certificate());
        for (CertificateChain child : chain.children()) {
            CertificateChain.visitAll(child, consumer);
        }
    }

    public static CertificateChain getRoot(String name) throws IOException {
        CertificateChain certificateChain;
        block8: {
            InputStream is = JarVerifier.class.getClassLoader().getResourceAsStream("certs/" + name + ".cer");
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                List<X509Certificate> certificates = cf.generateCertificates(is).stream().map(c -> (X509Certificate)c).toList();
                certificateChain = CertificateChain.getRoot(certificates);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CertificateException e) {
                    throw new RuntimeException("Failed to load certificate: " + name, e);
                }
            }
            is.close();
        }
        return certificateChain;
    }

    public static CertificateChain getRoot(Collection<X509Certificate> certificates) {
        HashMap<String, Impl> certificateNodes = new HashMap<String, Impl>();
        for (X509Certificate certificate : certificates) {
            Impl node2 = new Impl();
            node2.certificate = certificate;
            certificateNodes.put(certificate.getSubjectX500Principal().getName(), node2);
        }
        for (X509Certificate certificate : certificates) {
            Impl self;
            String issuer;
            String subject = certificate.getSubjectX500Principal().getName();
            if (subject.equals(issuer = certificate.getIssuerX500Principal().getName())) continue;
            Impl parent = (Impl)certificateNodes.get(issuer);
            if (parent == (self = (Impl)certificateNodes.get(subject))) {
                throw new IllegalStateException("Certificate " + subject + " is its own issuer");
            }
            if (parent == null) {
                throw new IllegalStateException("Certificate " + subject + " defines issuer " + issuer + " which is not in the chain");
            }
            parent.children.add(self);
            self.issuer = parent;
        }
        List<Impl> roots = certificateNodes.values().stream().filter(node -> node.issuer == null).toList();
        if (roots.size() != 1) {
            throw new IllegalStateException("Expected exactly one root certificate, but found " + roots.size());
        }
        return roots.get(0);
    }

    @FunctionalInterface
    public static interface CertificateConsumer {
        public void accept(X509Certificate var1) throws SignatureVerificationFailure;
    }

    public static class Impl
    implements CertificateChain {
        X509Certificate certificate;
        @Nullable Impl issuer;
        List<CertificateChain> children = new ArrayList<CertificateChain>();

        private Impl() {
        }

        @Override
        public X509Certificate certificate() {
            return this.certificate;
        }

        @Override
        public @Nullable CertificateChain issuer() {
            return this.issuer;
        }

        @Override
        public List<CertificateChain> children() {
            return this.children;
        }

        @Override
        public void verifyChainMatches(CertificateChain other) throws SignatureVerificationFailure {
            if (!this.certificate().equals(other.certificate())) {
                throw new SignatureVerificationFailure("Certificate mismatch: " + String.valueOf(this) + " != " + String.valueOf(other));
            }
            if (this.children().size() != other.children().size()) {
                throw new SignatureVerificationFailure("Certificate mismatch: " + String.valueOf(this) + " has " + this.children().size() + " children, but " + String.valueOf(other) + " has " + other.children().size());
            }
            if (this.children.isEmpty()) {
                return;
            }
            if (this.children.size() != 1) {
                throw new UnsupportedOperationException("Validating Certificate chain with multiple children is not supported");
            }
            this.children.get(0).verifyChainMatches(other.children().get(0));
        }

        public String toString() {
            return this.certificate.getSubjectX500Principal().getName();
        }
    }
}

