/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationNodeSerializer;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.ClassAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.SkipEmptyTypeAdapterFactory;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationNodeSerializer;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record AnnotationsData(Map<String, ClassAnnotationData> classes, String namespace) {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingStrategy((FieldNamingStrategy)FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).enableComplexMapKeySerialization().registerTypeAdapter(TypeAnnotationNode.class, (Object)new TypeAnnotationNodeSerializer()).registerTypeAdapter(AnnotationNode.class, (Object)new AnnotationNodeSerializer()).registerTypeAdapterFactory((TypeAdapterFactory)new SkipEmptyTypeAdapterFactory()).create();
    private static final Type LIST_TYPE = new TypeToken<List<AnnotationNode>>(){}.getType();
    private static final int CURRENT_VERSION = 1;

    public AnnotationsData {
        if (namespace == null) {
            namespace = MappingsNamespace.NAMED.toString();
        }
    }

    public AnnotationsData(String namespace) {
        this(new LinkedHashMap<String, ClassAnnotationData>(), namespace);
    }

    public AnnotationsData(AnnotationsData other) {
        this(AnnotationsData.copyMap(other.classes, ClassAnnotationData::new), other.namespace);
    }

    public static AnnotationsData read(Reader reader) {
        JsonObject json = (JsonObject)GSON.fromJson(reader, JsonObject.class);
        AnnotationsData.checkVersion(json);
        return (AnnotationsData)GSON.fromJson((JsonElement)json, AnnotationsData.class);
    }

    public static List<AnnotationsData> readList(Reader reader) {
        JsonObject json = (JsonObject)GSON.fromJson(reader, JsonObject.class);
        AnnotationsData.checkVersion(json);
        JsonElement values = json.get("values");
        if (values == null || values.isJsonNull()) {
            return List.of((AnnotationsData)GSON.fromJson((JsonElement)json, AnnotationsData.class));
        }
        return (List)GSON.fromJson(values, LIST_TYPE);
    }

    private static void checkVersion(JsonObject json) {
        if (!json.has("version")) {
            throw new JsonSyntaxException("Missing annotations version");
        }
        int version = json.getAsJsonPrimitive("version").getAsInt();
        if (version != 1) {
            throw new JsonSyntaxException("Invalid annotations version " + version + ". Try updating loom");
        }
    }

    public JsonObject toJson() {
        JsonObject json = GSON.toJsonTree((Object)this).getAsJsonObject();
        JsonObject result = new JsonObject();
        result.addProperty("version", (Number)1);
        result.asMap().putAll(json.asMap());
        return result;
    }

    public static JsonObject listToJson(List<AnnotationsData> annotationsData) {
        if (annotationsData.size() == 1) {
            return annotationsData.getFirst().toJson();
        }
        JsonObject result = new JsonObject();
        result.addProperty("version", (Number)1);
        result.add("values", GSON.toJsonTree(annotationsData));
        return result;
    }

    static <K, V> Map<K, V> copyMap(Map<K, V> map, UnaryOperator<V> valueCopier) {
        LinkedHashMap result = LinkedHashMap.newLinkedHashMap(map.size());
        map.forEach((key, value) -> result.put(key, valueCopier.apply(value)));
        return result;
    }

    static List<AnnotationNode> copyAnnotations(List<AnnotationNode> annotations) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>(annotations.size());
        for (AnnotationNode annotation : annotations) {
            AnnotationNode newAnnotation = new AnnotationNode(annotation.desc);
            annotation.accept((AnnotationVisitor)newAnnotation);
            result.add(newAnnotation);
        }
        return result;
    }

    static List<TypeAnnotationNode> copyTypeAnnotations(List<TypeAnnotationNode> annotations) {
        ArrayList<TypeAnnotationNode> result = new ArrayList<TypeAnnotationNode>(annotations.size());
        for (TypeAnnotationNode annotation : annotations) {
            TypeAnnotationNode newAnnotation = new TypeAnnotationNode(annotation.typeRef, annotation.typePath, annotation.desc);
            annotation.accept((AnnotationVisitor)newAnnotation);
            result.add(newAnnotation);
        }
        return result;
    }

    public AnnotationsData merge(AnnotationsData other) {
        if (!this.namespace.equals(other.namespace)) {
            throw new IllegalArgumentException("Cannot merge annotations from namespace " + other.namespace + " into annotations from namespace " + this.namespace);
        }
        LinkedHashMap<String, ClassAnnotationData> newClassData = new LinkedHashMap<String, ClassAnnotationData>(this.classes);
        other.classes.forEach((key, value) -> newClassData.merge((String)key, (ClassAnnotationData)value, ClassAnnotationData::merge));
        return new AnnotationsData(newClassData, this.namespace);
    }

    public AnnotationsData remap(TinyRemapper remapper, String newNamespace) {
        return new AnnotationsData(AnnotationsData.remapMap(this.classes, entry -> remapper.getEnvironment().getRemapper().map((String)entry.getKey()), entry -> ((ClassAnnotationData)entry.getValue()).remap((String)entry.getKey(), remapper)), newNamespace);
    }

    static AnnotationNode remap(AnnotationNode node, TinyRemapper remapper) {
        AnnotationNode remapped = new AnnotationNode(remapper.getEnvironment().getRemapper().mapDesc(node.desc));
        node.accept(remapper.createAnnotationRemapperVisitor((AnnotationVisitor)remapped, node.desc));
        return remapped;
    }

    static TypeAnnotationNode remap(TypeAnnotationNode node, TinyRemapper remapper) {
        TypeAnnotationNode remapped = new TypeAnnotationNode(node.typeRef, node.typePath, remapper.getEnvironment().getRemapper().mapDesc(node.desc));
        node.accept(remapper.createAnnotationRemapperVisitor((AnnotationVisitor)remapped, node.desc));
        return remapped;
    }

    static <K, V> Map<K, V> remapMap(Map<K, V> map, Function<Map.Entry<K, V>, K> keyRemapper, Function<Map.Entry<K, V>, V> valueRemapper) {
        LinkedHashMap<K, V> result = LinkedHashMap.newLinkedHashMap(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (result.put(keyRemapper.apply(entry), valueRemapper.apply(entry)) == null) continue;
            throw new IllegalStateException("Remapping annotations resulted in duplicate key: " + String.valueOf(keyRemapper.apply(entry)));
        }
        return result;
    }

    public static @Nullable AnnotationsData getRemappedAnnotations(MappingsNamespace targetNamespace, MappingConfiguration mappingConfiguration, Project project, ServiceFactory serviceFactory, String newNamespace) {
        List<AnnotationsData> datas = mappingConfiguration.getAnnotationsData();
        if (datas.isEmpty()) {
            return null;
        }
        AnnotationsData result = datas.getFirst().remap(targetNamespace, project, serviceFactory, newNamespace);
        for (int i = 1; i < datas.size(); ++i) {
            result = result.merge(datas.get(i).remap(targetNamespace, project, serviceFactory, newNamespace));
        }
        return result;
    }

    private AnnotationsData remap(MappingsNamespace targetNamespace, Project project, ServiceFactory serviceFactory, String newNamespace) {
        if (this.namespace.equals(targetNamespace.toString())) {
            return this;
        }
        TinyRemapperService remapperService = (TinyRemapperService)serviceFactory.get(TinyRemapperService.createSimple(project, (Provider<String>)project.provider(() -> this.namespace), (Provider<String>)project.provider(() -> newNamespace), TinyRemapperService.ClasspathLibraries.EXCLUDE));
        TinyRemapper remapper = remapperService.getTinyRemapperForRemapping();
        return this.remap(remapper, newNamespace);
    }
}

