/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.MappingsSpec;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpec;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsLayer;
import net.fabricmc.loom.configuration.providers.mappings.extras.signatures.SignatureFixesLayer;
import net.fabricmc.loom.configuration.providers.mappings.extras.unpick.UnpickLayer;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsCompleter;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;

public class LayeredMappingsProcessor {
    private final LayeredMappingSpec layeredMappingSpec;
    private final boolean noIntermediateMappings;

    public LayeredMappingsProcessor(LayeredMappingSpec spec, boolean noIntermediateMappings) {
        this.layeredMappingSpec = spec;
        this.noIntermediateMappings = noIntermediateMappings;
    }

    public List<MappingLayer> resolveLayers(MappingContext context) {
        LinkedList layers = new LinkedList();
        ArrayList visitedLayers = new ArrayList();
        for (MappingsSpec<?> spec : this.layeredMappingSpec.layers()) {
            Object layer = spec.createLayer(context);
            for (Class<? extends MappingLayer> dependentLayer : layer.dependsOn()) {
                if (visitedLayers.contains(dependentLayer)) continue;
                throw new RuntimeException("Layer %s depends on %s".formatted(layer.getClass().getName(), dependentLayer.getName()));
            }
            layers.add(layer);
            visitedLayers.add(layer.getClass());
        }
        return Collections.unmodifiableList(layers);
    }

    public MemoryMappingTree getMappings(List<MappingLayer> layers) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        for (MappingLayer layer : layers) {
            MemoryMappingTree workingTree;
            boolean rebuild;
            boolean bl = rebuild = layer.getSourceNamespace() != MappingsNamespace.NAMED;
            if (rebuild) {
                MemoryMappingTree tempTree = new MemoryMappingTree();
                if (mappingTree.getSrcNamespace() != null) {
                    MappingSourceNsSwitch sourceNsSwitch = new MappingSourceNsSwitch((MappingVisitor)tempTree, layer.getSourceNamespace().toString());
                    mappingTree.accept((MappingVisitor)sourceNsSwitch);
                }
                workingTree = tempTree;
            } else {
                workingTree = mappingTree;
            }
            try {
                layer.visit((MappingVisitor)workingTree);
            }
            catch (IOException e) {
                throw new IOException("Failed to visit: " + String.valueOf(layer.getClass()), e);
            }
            if (!rebuild) continue;
            mappingTree = new MemoryMappingTree();
            workingTree.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)mappingTree, MappingsNamespace.NAMED.toString()));
        }
        if (this.noIntermediateMappings) {
            MemoryMappingTree completedTree = new MemoryMappingTree();
            mappingTree.accept((MappingVisitor)new MappingNsCompleter((MappingVisitor)completedTree, Map.of("intermediary", "named")));
            return completedTree;
        }
        return mappingTree;
    }

    public List<AnnotationsData> getAnnotationsData(List<MappingLayer> layers) throws IOException {
        ArrayList<AnnotationsData> result = new ArrayList<AnnotationsData>();
        for (MappingLayer layer : layers) {
            AnnotationsLayer annotationsLayer;
            AnnotationsData annotationsData;
            if (!(layer instanceof AnnotationsLayer) || (annotationsData = (annotationsLayer = (AnnotationsLayer)((Object)layer)).getAnnotationsData()) == null) continue;
            result.add(annotationsData);
        }
        return result;
    }

    @Nullable
    public Map<String, String> getSignatureFixes(List<MappingLayer> layers) {
        HashMap<String, String> signatureFixes = new HashMap<String, String>();
        for (MappingLayer layer : layers) {
            if (!(layer instanceof SignatureFixesLayer)) continue;
            SignatureFixesLayer signatureFixesLayer = (SignatureFixesLayer)((Object)layer);
            signatureFixes.putAll(signatureFixesLayer.getSignatureFixes());
        }
        if (signatureFixes.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableMap(signatureFixes);
    }

    @Nullable
    public UnpickLayer.UnpickData getUnpickData(List<MappingLayer> layers) throws IOException {
        ArrayList<UnpickLayer.UnpickData> unpickDataList = new ArrayList<UnpickLayer.UnpickData>();
        for (MappingLayer layer : layers) {
            UnpickLayer unpickLayer;
            UnpickLayer.UnpickData data;
            if (!(layer instanceof UnpickLayer) || (data = (unpickLayer = (UnpickLayer)((Object)layer)).getUnpickData()) == null) continue;
            unpickDataList.add(data);
        }
        if (unpickDataList.isEmpty()) {
            return null;
        }
        if (unpickDataList.size() != 1) {
            throw new UnsupportedOperationException("Only one unpick layer is currently supported.");
        }
        return (UnpickLayer.UnpickData)unpickDataList.get(0);
    }
}

