/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;

public class AddConstructorMappingVisitor
extends ForwardingMappingVisitor {
    private boolean inConstructor;
    private boolean[] namespaceVisited;

    public AddConstructorMappingVisitor(MappingVisitor next) {
        super(next);
    }

    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        this.namespaceVisited = new boolean[dstNamespaces.size()];
        super.visitNamespaces(srcNamespace, dstNamespaces);
    }

    public boolean visitMethod(String srcName, String srcDesc) throws IOException {
        if ("<init>".equals(srcName)) {
            this.inConstructor = true;
            Arrays.fill(this.namespaceVisited, false);
        } else {
            this.inConstructor = false;
        }
        return super.visitMethod(srcName, srcDesc);
    }

    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        if (this.inConstructor) {
            this.inConstructor = false;
            for (int i = 0; i < this.namespaceVisited.length; ++i) {
                if (this.namespaceVisited[i]) continue;
                this.visitDstName(targetKind, i, "<init>");
            }
        }
        return super.visitElementContent(targetKind);
    }

    public void visitDstName(MappedElementKind targetKind, int namespace, String name) throws IOException {
        this.namespaceVisited[namespace] = true;
        super.visitDstName(targetKind, namespace, name);
    }
}

