/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.AnnotationsData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.ClassAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.GenericAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.MethodAnnotationData;
import net.fabricmc.loom.configuration.providers.mappings.extras.annotations.TypeAnnotationKey;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public record AnnotationsApplyVisitor(AnnotationsData annotationsData) implements TinyRemapper.ApplyVisitorProvider
{
    public ClassVisitor insertApplyVisitor(TrClass cls, ClassVisitor next) {
        String deobfName = cls.getEnvironment().getRemapper().map(cls.getName());
        ClassAnnotationData classData = this.annotationsData.classes().get(deobfName);
        if (classData == null) {
            return next;
        }
        return new AnnotationsApplyClassVisitor(next, classData);
    }

    public static class AnnotationsApplyClassVisitor
    extends ClassVisitor {
        private final ClassAnnotationData classData;
        private boolean isRecord;
        private final List<MethodNode> storedRecordMethods = new ArrayList<MethodNode>();
        private final StringBuilder canonicalConstructorDesc = new StringBuilder("(");
        private final List<@Nullable GenericAnnotationData> recordComponentAnnotationData = new ArrayList<GenericAnnotationData>();
        private boolean hasAddedAnnotations;

        public AnnotationsApplyClassVisitor(ClassVisitor cv, ClassAnnotationData classData) {
            super(589824, cv);
            this.classData = classData;
            this.hasAddedAnnotations = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isRecord = ((access = this.classData.modifyAccessFlags(access)) & 0x10000) != 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (this.classData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.classData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public void visitNestMember(String nestMember) {
            this.addClassAnnotations();
            super.visitNestMember(nestMember);
        }

        public void visitPermittedSubclass(String permittedSubclass) {
            this.addClassAnnotations();
            super.visitPermittedSubclass(permittedSubclass);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.addClassAnnotations();
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
            this.addClassAnnotations();
            GenericAnnotationData fieldData = this.classData.getFieldData(name, descriptor);
            this.canonicalConstructorDesc.append(descriptor);
            this.recordComponentAnnotationData.add(fieldData);
            RecordComponentVisitor rcv = super.visitRecordComponent(name, descriptor, signature);
            if (rcv == null) {
                return null;
            }
            if (fieldData == null) {
                return rcv;
            }
            return new ApplyRecordComponentVisitor(rcv, fieldData);
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            this.addClassAnnotations();
            GenericAnnotationData fieldData = this.classData.getFieldData(name, descriptor);
            if (fieldData == null) {
                return super.visitField(access, name, descriptor, signature, value);
            }
            FieldVisitor fv = super.visitField(fieldData.modifyAccessFlags(access), name, descriptor, signature, value);
            if (fv == null) {
                return null;
            }
            return new ApplyFieldVisitor(fv, fieldData);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            this.addClassAnnotations();
            if (this.isRecord) {
                MethodNode node = new MethodNode(access, name, descriptor, signature, exceptions);
                this.storedRecordMethods.add(node);
                return node;
            }
            return this.visitMethodInner(access, name, descriptor, signature, exceptions);
        }

        private MethodVisitor visitMethodInner(int access, String name, String descriptor, String signature, String[] exceptions) {
            GenericAnnotationData fieldData;
            MethodAnnotationData methodData = this.classData.getMethodData(name, descriptor);
            if (this.isRecord && "<init>".equals(name) && this.canonicalConstructorDesc.toString().equals(descriptor)) {
                MethodVisitor mv = super.visitMethod(methodData != null ? methodData.modifyAccessFlags(access) : access, name, descriptor, signature, exceptions);
                return new CanonicalConstructorApplyVisitor(mv, methodData, descriptor, this.recordComponentAnnotationData);
            }
            if (methodData != null) {
                MethodVisitor mv = super.visitMethod(methodData.modifyAccessFlags(access), name, descriptor, signature, exceptions);
                if (mv == null) {
                    return null;
                }
                return new ApplyMethodVisitor(mv, methodData, descriptor);
            }
            if (this.isRecord && descriptor.startsWith("()") && (fieldData = this.classData.getFieldData(name, descriptor.substring(2))) != null) {
                MethodVisitor mv = super.visitMethod(fieldData.modifyAccessFlags(access), name, descriptor, signature, exceptions);
                if (mv == null) {
                    return null;
                }
                return new RecordComponentGetterApplyVisitor(mv, fieldData);
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        public void visitEnd() {
            this.addClassAnnotations();
            this.canonicalConstructorDesc.append(")V");
            for (MethodNode method : this.storedRecordMethods) {
                MethodVisitor mv = this.visitMethodInner(method.access, method.name, method.desc, method.signature, method.exceptions == null ? null : method.exceptions.toArray(new String[0]));
                if (mv == null) continue;
                method.accept(mv);
            }
            super.visitEnd();
        }

        private void addClassAnnotations() {
            AnnotationVisitor av;
            if (this.hasAddedAnnotations) {
                return;
            }
            this.hasAddedAnnotations = true;
            for (AnnotationNode annotation : this.classData.annotationsToAdd()) {
                av = this.cv.visitAnnotation(annotation.desc, false);
                if (av == null) continue;
                annotation.accept(av);
            }
            for (TypeAnnotationNode typeAnnotation : this.classData.typeAnnotationsToAdd()) {
                av = this.cv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                if (av == null) continue;
                typeAnnotation.accept(av);
            }
        }
    }

    private static class RecordComponentGetterApplyVisitor
    extends MethodVisitor {
        private final GenericAnnotationData fieldData;

        private RecordComponentGetterApplyVisitor(MethodVisitor mv, GenericAnnotationData fieldData) {
            super(589824, mv);
            this.fieldData = fieldData;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.fieldData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            int fieldTypeRef = typeRef;
            if (new TypeReference(fieldTypeRef).getSort() == 20) {
                fieldTypeRef = TypeReference.newTypeReference((int)19).getValue();
            }
            if (this.fieldData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(fieldTypeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public void visitEnd() {
            for (AnnotationNode annotation : this.fieldData.annotationsToAdd()) {
                AnnotationVisitor av = this.mv.visitAnnotation(annotation.desc, false);
                if (av == null) continue;
                annotation.accept(av);
            }
            for (TypeAnnotationNode typeAnnotation : this.fieldData.typeAnnotationsToAdd()) {
                AnnotationVisitor av;
                int methodTypeRef = typeAnnotation.typeRef;
                if (new TypeReference(methodTypeRef).getSort() == 20) {
                    methodTypeRef = TypeReference.newTypeReference((int)19).getValue();
                }
                if ((av = this.mv.visitTypeAnnotation(methodTypeRef, typeAnnotation.typePath, typeAnnotation.desc, false)) == null) continue;
                typeAnnotation.accept(av);
            }
            super.visitEnd();
        }
    }

    private static class CanonicalConstructorApplyVisitor
    extends AbstractApplyMethodVisitor {
        private final List<@Nullable GenericAnnotationData> parameterData;

        CanonicalConstructorApplyVisitor(MethodVisitor mv, @Nullable MethodAnnotationData methodData, String descriptor, List<@Nullable GenericAnnotationData> parameterData) {
            super(mv, methodData, descriptor);
            this.parameterData = parameterData;
        }

        @Override
        @Nullable
        protected GenericAnnotationData getParameterData(int parameterIndex) {
            return parameterIndex >= 0 && parameterIndex < this.parameterData.size() ? this.parameterData.get(parameterIndex) : null;
        }

        @Override
        protected boolean hasAnnotableParameters() {
            return this.parameterData.stream().anyMatch(Objects::nonNull);
        }

        @Override
        protected void forEachParameterData(BiConsumer<Integer, GenericAnnotationData> action) {
            for (int i = 0; i < this.parameterData.size(); ++i) {
                GenericAnnotationData data = this.parameterData.get(i);
                if (data == null) continue;
                action.accept(i, data);
            }
        }
    }

    private static class ApplyMethodVisitor
    extends AbstractApplyMethodVisitor {
        ApplyMethodVisitor(MethodVisitor mv, MethodAnnotationData methodData, String descriptor) {
            super(mv, methodData, descriptor);
        }

        @Override
        @Nullable
        protected GenericAnnotationData getParameterData(int parameterIndex) {
            return this.methodData == null ? null : this.methodData.parameters().get(parameterIndex);
        }

        @Override
        protected boolean hasAnnotableParameters() {
            return this.methodData != null && !this.methodData.parameters().isEmpty();
        }

        @Override
        protected void forEachParameterData(BiConsumer<Integer, GenericAnnotationData> action) {
            if (this.methodData != null) {
                this.methodData.parameters().forEach(action);
            }
        }
    }

    private static abstract class AbstractApplyMethodVisitor
    extends MethodVisitor {
        @Nullable
        protected final MethodAnnotationData methodData;
        private final String descriptor;
        private int syntheticParameterCount = 0;
        private boolean visitedAnnotableParameterCount = false;
        private boolean hasAddedAnnotations = false;

        AbstractApplyMethodVisitor(MethodVisitor mv, @Nullable MethodAnnotationData methodData, String descriptor) {
            super(589824, mv);
            this.methodData = methodData;
            this.descriptor = descriptor;
        }

        @Nullable
        protected abstract GenericAnnotationData getParameterData(int var1);

        protected abstract boolean hasAnnotableParameters();

        protected abstract void forEachParameterData(BiConsumer<Integer, GenericAnnotationData> var1);

        public void visitParameter(String name, int access) {
            if ((access & 0x1000) != 0) {
                ++this.syntheticParameterCount;
            }
            super.visitParameter(name, access);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.methodData != null && this.methodData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (this.methodData != null && this.methodData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            GenericAnnotationData parameterData = this.getParameterData(parameter);
            if (parameterData != null && parameterData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitParameterAnnotation(parameter, descriptor, visible);
        }

        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            if (!visible && this.hasAnnotableParameters()) {
                parameterCount = Math.max(parameterCount, Type.getArgumentCount((String)this.descriptor) - this.syntheticParameterCount);
                this.visitedAnnotableParameterCount = true;
            }
            super.visitAnnotableParameterCount(parameterCount, visible);
        }

        public void visitCode() {
            this.addMethodAnnotations();
            super.visitCode();
        }

        public void visitEnd() {
            this.addMethodAnnotations();
            super.visitEnd();
        }

        void addMethodAnnotations() {
            if (this.hasAddedAnnotations) {
                return;
            }
            this.hasAddedAnnotations = true;
            if (this.methodData != null) {
                AnnotationVisitor av;
                for (AnnotationNode annotation : this.methodData.annotationsToAdd()) {
                    av = this.mv.visitAnnotation(annotation.desc, false);
                    if (av == null) continue;
                    annotation.accept(av);
                }
                for (TypeAnnotationNode typeAnnotation : this.methodData.typeAnnotationsToAdd()) {
                    av = this.mv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                    if (av == null) continue;
                    typeAnnotation.accept(av);
                }
            }
            if (!this.visitedAnnotableParameterCount && this.hasAnnotableParameters()) {
                this.mv.visitAnnotableParameterCount(Type.getArgumentCount((String)this.descriptor) - this.syntheticParameterCount, false);
                this.visitedAnnotableParameterCount = true;
            }
            this.forEachParameterData((paramIndex, paramData) -> {
                for (AnnotationNode annotation : paramData.annotationsToAdd()) {
                    AnnotationVisitor av = this.mv.visitParameterAnnotation(paramIndex.intValue(), annotation.desc, false);
                    if (av == null) continue;
                    annotation.accept(av);
                }
            });
        }
    }

    private static class ApplyFieldVisitor
    extends FieldVisitor {
        private final GenericAnnotationData fieldData;

        ApplyFieldVisitor(FieldVisitor fv, GenericAnnotationData fieldData) {
            super(589824, fv);
            this.fieldData = fieldData;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.fieldData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (this.fieldData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public void visitEnd() {
            AnnotationVisitor av;
            for (AnnotationNode annotation : this.fieldData.annotationsToAdd()) {
                av = this.fv.visitAnnotation(annotation.desc, false);
                if (av == null) continue;
                annotation.accept(av);
            }
            for (TypeAnnotationNode typeAnnotation : this.fieldData.typeAnnotationsToAdd()) {
                av = this.fv.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                if (av == null) continue;
                typeAnnotation.accept(av);
            }
            super.visitEnd();
        }
    }

    private static class ApplyRecordComponentVisitor
    extends RecordComponentVisitor {
        private final GenericAnnotationData fieldData;

        ApplyRecordComponentVisitor(RecordComponentVisitor rcv, GenericAnnotationData fieldData) {
            super(589824, rcv);
            this.fieldData = fieldData;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.fieldData.annotationsToRemove().contains(Type.getType((String)descriptor).getInternalName())) {
                return null;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            if (this.fieldData.typeAnnotationsToRemove().contains(new TypeAnnotationKey(typeRef, typePath.toString(), Type.getType((String)descriptor).getInternalName()))) {
                return null;
            }
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public void visitEnd() {
            AnnotationVisitor av;
            for (AnnotationNode annotation : this.fieldData.annotationsToAdd()) {
                av = this.delegate.visitAnnotation(annotation.desc, false);
                if (av == null) continue;
                annotation.accept(av);
            }
            for (TypeAnnotationNode typeAnnotation : this.fieldData.typeAnnotationsToAdd()) {
                av = this.delegate.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false);
                if (av == null) continue;
                typeAnnotation.accept(av);
            }
            super.visitEnd();
        }
    }
}

