/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunTask
extends JavaExec {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRunTask.class);

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Input
    protected abstract Property<String> getInternalRunDir();

    @Input
    protected abstract MapProperty<String, Object> getInternalEnvironmentVars();

    @Input
    protected abstract ListProperty<String> getInternalJvmArgs();

    @Input
    protected abstract Property<Boolean> getUseArgFile();

    @Input
    protected abstract Property<String> getProjectDir();

    @Input
    protected abstract Property<String> getArgFilePath();

    @Input
    protected abstract Property<Boolean> getUseXvfb();

    @InputFiles
    protected abstract ConfigurableFileCollection getInternalClasspath();

    public AbstractRunTask(Function<Project, RunConfig> configProvider) {
        this.setGroup("fabric");
        Provider config = this.getProject().provider(() -> (RunConfig)configProvider.apply(this.getProject()));
        this.getInternalClasspath().from(new Object[]{config.map(runConfig -> runConfig.sourceSet.getRuntimeClasspath().filter((Spec)new LibraryFilter(((RunConfig)config.get()).getExcludedLibraryPaths(this.getProject()), ((RunConfig)config.get()).configName)))});
        this.getArgumentProviders().add(() -> ((RunConfig)config.get()).programArgs);
        this.getMainClass().set(config.map(runConfig -> runConfig.mainClass));
        this.getJvmArguments().addAll(this.getProject().provider(this::getGameJvmArgs));
        this.getInternalRunDir().set(config.map(runConfig -> runConfig.runDir));
        this.getInternalEnvironmentVars().set(config.map(runConfig -> runConfig.environmentVariables));
        this.getInternalJvmArgs().set(config.map(runConfig -> runConfig.vmArgs));
        this.getUseArgFile().set(this.getProject().provider(this::canUseArgFile));
        this.getProjectDir().set((Object)this.getProject().getProjectDir().getAbsolutePath());
        this.getUseXvfb().convention(this.getProject().getProviders().environmentVariable("CI").map(value -> Platform.CURRENT.getOperatingSystem().isLinux()).orElse((Object)false));
        File buildCache = LoomGradleExtension.get(this.getProject()).getFiles().getProjectBuildCache();
        File argFile = new File(buildCache, "argFiles/" + this.getName());
        this.getArgFilePath().set((Object)argFile.getAbsolutePath());
    }

    private boolean canUseArgFile() {
        if (!this.canPathBeASCIIEncoded()) {
            return false;
        }
        return this.getJavaVersion().isJava9Compatible();
    }

    private boolean canPathBeASCIIEncoded() {
        CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();
        return asciiEncoder.canEncode(this.getProject().getProjectDir().getAbsolutePath()) && asciiEncoder.canEncode(this.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
    }

    public void exec() {
        if (((Boolean)this.getUseArgFile().get()).booleanValue()) {
            LOGGER.debug("Using arg file for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.getObjectFactory().fileCollection());
        } else {
            LOGGER.debug("Using bare classpath for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.getInternalClasspath());
        }
        this.setWorkingDir(new File((String)this.getProjectDir().get(), (String)this.getInternalRunDir().get()));
        this.environment((Map)this.getInternalEnvironmentVars().get());
        if (((Boolean)this.getUseXvfb().get()).booleanValue()) {
            LOGGER.info("Using XVFB for headless client execution");
            this.execWithXvfb();
        } else {
            super.exec();
        }
    }

    private void execWithXvfb() {
        String xvfbRunPath = "/usr/bin/xvfb-run";
        String javaExec = ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(xvfbRunPath);
        commandLine.add("--auto-servernum");
        commandLine.add(javaExec);
        commandLine.addAll((Collection)this.getJvmArguments().get());
        commandLine.add((String)this.getMainClass().get());
        commandLine.addAll(this.getArgs());
        this.getExecOperations().exec(execSpec -> {
            execSpec.setCommandLine(commandLine);
            execSpec.setWorkingDir(this.getWorkingDir());
            execSpec.setEnvironment(this.getEnvironment());
        });
    }

    public void setWorkingDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        super.setWorkingDir(dir);
    }

    private List<String> getGameJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (((Boolean)this.getUseArgFile().get()).booleanValue()) {
            String content = "-classpath\n" + this.getInternalClasspath().getFiles().stream().map(File::getAbsolutePath).map(AbstractRunTask::quoteArg).collect(Collectors.joining(File.pathSeparator));
            try {
                Path argsFile = Paths.get((String)this.getArgFilePath().get(), new String[0]);
                Files.createDirectories(argsFile.getParent(), new FileAttribute[0]);
                Files.writeString(argsFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                args.add("@" + String.valueOf(argsFile.toAbsolutePath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create classpath file", e);
            }
        }
        args.addAll((Collection)this.getInternalJvmArgs().get());
        return args;
    }

    private static String quoteArg(String arg) {
        String specials = " #'\"\n\r\t\f";
        if (!AbstractRunTask.containsAnyChar(arg, " #'\"\n\r\t\f")) {
            return arg;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        block8: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '\'': {
                    sb.append('\"').append(c).append('\"');
                    continue block8;
                }
                case '\"': {
                    sb.append("\"\\\"\"");
                    continue block8;
                }
                case '\n': {
                    sb.append("\"\\n\"");
                    continue block8;
                }
                case '\r': {
                    sb.append("\"\\r\"");
                    continue block8;
                }
                case '\t': {
                    sb.append("\"\\t\"");
                    continue block8;
                }
                case '\f': {
                    sb.append("\"\\f\"");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean containsAnyChar(String value, String chars) {
        return chars.length() > value.length() ? AbstractRunTask.containsAnyChar(value, chars, 0, value.length()) : AbstractRunTask.containsAnyChar(chars, value, 0, chars.length());
    }

    public static boolean containsAnyChar(String value, String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public JavaExec setClasspath(FileCollection classpath) {
        this.getInternalClasspath().setFrom((Iterable)classpath);
        return this;
    }

    public JavaExec classpath(Object ... paths) {
        this.getInternalClasspath().from(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.getInternalClasspath();
    }

    public record LibraryFilter(List<String> excludedLibraryPaths, String configName) implements Spec<File>
    {
        public boolean isSatisfiedBy(File element) {
            if (this.excludedLibraryPaths.contains(element.getAbsolutePath())) {
                LOGGER.debug("Excluding library {} from {} run config", (Object)element.getName(), (Object)this.configName);
                return false;
            }
            return true;
        }
    }
}

