/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.extras.annotations;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

class SkipEmptyTypeAdapterFactory
implements TypeAdapterFactory {
    SkipEmptyTypeAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        final boolean isMap = Map.class.isAssignableFrom(rawType);
        if (!isMap && !Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(this){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null || this.isEmpty(value)) {
                    delegate.write(out, null);
                } else {
                    delegate.write(out, value);
                }
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }

            private boolean isEmpty(T value) {
                return isMap ? ((Map)value).isEmpty() : ((Collection)value).isEmpty();
            }
        };
    }
}

