/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.lorenztiny.TinyMappingsReader;
import net.fabricmc.mappingio.tree.MappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;

public final class LorenzMappingService
extends Service<Options> {
    public static final ServiceType<Options, LorenzMappingService> TYPE = new ServiceType<Options, LorenzMappingService>(Options.class, LorenzMappingService.class);
    private final Supplier<MappingSet> mappings = Lazy.of(this::readMappings);

    public static Provider<Options> createOptions(Project project, MappingConfiguration mappingConfiguration, MappingsNamespace from, MappingsNamespace to) {
        return TYPE.create(project, (Action<Options>)((Action)options -> options.getMappings().set(MappingsService.createOptions(project, mappingConfiguration.tinyMappings, from.toString(), to.toString(), false))));
    }

    public LorenzMappingService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    private MappingSet readMappings() {
        MappingSet mappingSet;
        MappingsService mappingsService = (MappingsService)this.getServiceFactory().get((MappingsService.Options)((Options)this.getOptions()).getMappings().get());
        TinyMappingsReader reader = new TinyMappingsReader((MappingTree)mappingsService.getMemoryMappingTree(), mappingsService.getFrom(), mappingsService.getTo());
        try {
            mappingSet = reader.read();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read lorenz mappings", e);
            }
        }
        reader.close();
        return mappingSet;
    }

    public MappingSet getMappings() {
        return this.mappings.get();
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MappingsService.Options> getMappings();
    }
}

