/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.mixin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.util.LoomVersions;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public abstract class AnnotationProcessorInvoker<T extends Task> {
    public static final String JAVA = "java";
    public static final String SCALA = "scala";
    public static final String GROOVY = "groovy";
    private static final Pattern MSG_KEY_PATTERN = Pattern.compile("^[A-Z]+[A-Z_]+$");
    private static final Pattern MSG_VALUE_PATTERN = Pattern.compile("^(note|warning|error|disabled)$");
    protected final Project project;
    private final LoomGradleExtension loomExtension;
    protected final MixinExtension mixinExtension;
    protected final Map<SourceSet, TaskProvider<T>> invokerTasks;
    private final String name;
    private final Collection<Configuration> apConfigurations;

    protected AnnotationProcessorInvoker(Project project, Collection<Configuration> apConfigurations, Map<SourceSet, TaskProvider<T>> invokerTasks, String name) {
        this.project = project;
        this.loomExtension = LoomGradleExtension.get(project);
        this.mixinExtension = this.loomExtension.getMixin();
        this.apConfigurations = apConfigurations;
        this.invokerTasks = invokerTasks;
        this.name = name;
    }

    protected static Collection<Configuration> getApConfigurations(Project project, Function<SourceSet, String> getApConfigNameFunc) {
        MixinExtension mixin = LoomGradleExtension.get(project).getMixin();
        return mixin.getApConfigurationsStream(getApConfigNameFunc).collect(Collectors.toList());
    }

    protected abstract void passArgument(T var1, String var2, String var3);

    protected abstract File getRefmapDestinationDir(T var1);

    protected final String getRefmapDestination(T task, String refmapName) throws IOException {
        return new File(this.getRefmapDestinationDir(task), refmapName).getCanonicalPath();
    }

    private void passMixinArguments(final T task, SourceSet sourceSet) {
        try {
            final LoomGradleExtension loom = LoomGradleExtension.get(this.project);
            final String refmapName = (String)Objects.requireNonNull(MixinExtension.getMixinInformationContainer(sourceSet)).refmapNameProvider().get();
            final File mixinMappings = AnnotationProcessorInvoker.getMixinMappingsForSourceSet(this.project, sourceSet);
            task.getOutputs().file((Object)mixinMappings).withPropertyName("mixin-ap-" + sourceSet.getName() + "-" + this.name).optional();
            HashMap<String, String> args = new HashMap<String, String>(){
                {
                    this.put("inMapFileNamedIntermediary", loom.getMappingConfiguration().tinyMappings.toFile().getCanonicalPath());
                    this.put("outMapFileNamedIntermediary", mixinMappings.getCanonicalPath());
                    this.put("outRefMapFile", AnnotationProcessorInvoker.this.getRefmapDestination(task, refmapName));
                    this.put("defaultObfuscationEnv", "named:" + (String)loom.getMixin().getRefmapTargetNamespace().get());
                    this.put("quiet", "true");
                }
            };
            if (((Boolean)this.mixinExtension.getShowMessageTypes().get()).booleanValue()) {
                args.put("showMessageTypes", "true");
            }
            ((Map)this.mixinExtension.getMessages().get()).forEach((key, value) -> {
                AnnotationProcessorInvoker.checkPattern(key, MSG_KEY_PATTERN);
                AnnotationProcessorInvoker.checkPattern(value, MSG_VALUE_PATTERN);
                args.put("MSG_" + key, (String)value);
            });
            this.project.getLogger().debug("Outputting refmap to dir: " + String.valueOf(this.getRefmapDestinationDir(task)) + " for compile task: " + String.valueOf(task));
            args.forEach((k, v) -> this.passArgument(task, (String)k, (String)v));
        }
        catch (IOException e) {
            this.project.getLogger().error("Could not configure mixin annotation processors", (Throwable)e);
        }
    }

    public void configureMixin() {
        ConfigurationContainer configs = this.project.getConfigurations();
        MinecraftSourceSets minecraftSourceSets = MinecraftSourceSets.get(this.project);
        if (!IdeaUtils.isIdeaSync()) {
            for (Configuration configuration : this.apConfigurations) {
                this.project.getLogger().info("Adding mixin to classpath of AP config: " + configuration.getName());
                configuration.extendsFrom(new Configuration[]{configs.getByName("loaderLibraries"), configs.getByName("mappingsFinal")});
                this.project.getDependencies().add(configuration.getName(), (Object)LoomVersions.MIXIN_COMPILE_EXTENSIONS.mavenNotation());
            }
        }
        for (Map.Entry entry : this.invokerTasks.entrySet()) {
            ((TaskProvider)entry.getValue()).configure(t -> this.passMixinArguments(t, (SourceSet)entry.getKey()));
        }
    }

    private static void checkPattern(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Mixin argument (%s) does not match pattern (%s)".formatted(input, pattern.toString()));
        }
    }

    public static File getMixinMappingsForSourceSet(Project project, SourceSet sourceSet) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        return new File(extension.getFiles().getProjectBuildCache(), "mixin-map-" + extension.getMappingConfiguration().mappingsIdentifier() + "." + sourceSet.getName() + ".tiny");
    }
}

