/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyOptions;
import net.fabricmc.loom.configuration.mods.dependency.SimpleModDependency;
import net.fabricmc.loom.configuration.mods.dependency.SplitModDependency;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.jspecify.annotations.Nullable;

public abstract sealed class ModDependency
permits SplitModDependency, SimpleModDependency {
    private final ArtifactRef artifact;
    private final ArtifactMetadata metadata;
    private final String group;
    private final String name;
    private final String version;
    private final @Nullable String classifier;
    private final ModDependencyOptions options;

    public ModDependency(ArtifactRef artifact, ArtifactMetadata metadata, ModDependencyOptions options) {
        this.artifact = artifact;
        this.metadata = metadata;
        this.group = artifact.group();
        this.name = artifact.name();
        this.version = artifact.version();
        this.classifier = artifact.classifier();
        this.options = options;
    }

    public abstract boolean isCacheInvalid(Project var1, @Nullable String var2);

    public abstract void copyToCache(Project var1, Path var2, @Nullable String var3) throws IOException;

    public abstract void applyToProject(Project var1);

    protected LocalMavenHelper createMavenHelper(Project project, @Nullable String type) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Path root = extension.getFiles().getRemappedModCache().toPath();
        String fullName = this.getName() + (String)(type != null ? "-" + type : "");
        return new LocalMavenHelper(this.getGroup(), fullName, this.version, this.classifier, root, this.getSnapshotVersion());
    }

    private @Nullable String getSnapshotVersion() {
        ArtifactRef.ResolvedArtifactRef resolvedArtifactRef;
        ComponentIdentifier componentIdentifier;
        ArtifactRef artifactRef = this.artifact;
        if (artifactRef instanceof ArtifactRef.ResolvedArtifactRef && (componentIdentifier = (resolvedArtifactRef = (ArtifactRef.ResolvedArtifactRef)artifactRef).artifact().getId().getComponentIdentifier()) instanceof MavenUniqueSnapshotComponentIdentifier) {
            MavenUniqueSnapshotComponentIdentifier mavenUniqueId = (MavenUniqueSnapshotComponentIdentifier)componentIdentifier;
            return mavenUniqueId.getSnapshotVersion();
        }
        return null;
    }

    public ArtifactRef getInputArtifact() {
        return this.artifact;
    }

    public ArtifactMetadata getMetadata() {
        return this.metadata;
    }

    protected String getName() {
        return "%s-%s".formatted(this.name, this.options.getCacheKey());
    }

    protected String getGroup() {
        return "remapped.%s".formatted(this.group);
    }

    protected String getVersion() {
        return this.version;
    }

    public Path getInputFile() {
        return this.artifact.path();
    }

    public Path getWorkingFile(Project project, @Nullable String classifier) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String fileName = classifier == null ? String.format("%s-%s-%s.jar", this.getGroup(), this.getName(), this.version) : String.format("%s-%s-%s-%s.jar", this.getGroup(), this.getName(), this.version, classifier);
        return extension.getFiles().getProjectBuildCache().toPath().resolve("remapped_working").resolve(fileName);
    }

    public ModDependencyOptions getOptions() {
        return this.options;
    }

    public String toString() {
        return "ModDependency{group='" + this.group + "', name='" + this.name + "', version='" + this.version + "', classifier='" + this.classifier + "'}";
    }
}

